/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.ReportAggregates;
import com.aventstack.extentreports.reporter.BasicFileReporter;
import com.aventstack.extentreports.reporter.configuration.ExtentSparkReporterConfiguration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtentSparkReporter
extends BasicFileReporter {
    private static final Logger logger = Logger.getLogger(ExtentSparkReporter.class.getName());
    private static final String REPORTER_NAME = "spark";
    private static final String TEST_TEMPLATE_NAME = "spark/test.ftl";
    private static final String TAG_TEMPLATE_NAME = "spark/tag.ftl";
    private static final String EXCEPTION_TEMPLATE_NAME = "spark/exception.ftl";
    private static final String DASHBOARD_TEMPLATE_NAME = "spark/dashboard.ftl";
    private static final String[] DEFAULT_CONFIG_FILE_PATH = new String[]{"spark.properties", "src/main/resources/spark.properties"};
    private ExtentSparkReporterConfiguration userConfig = new ExtentSparkReporterConfiguration(this);

    public ExtentSparkReporter(String path) {
        super(path);
        this.init(DEFAULT_CONFIG_FILE_PATH, this.config());
    }

    public ExtentSparkReporter(File file) {
        super(file);
        this.init(DEFAULT_CONFIG_FILE_PATH, this.config());
    }

    public ExtentSparkReporterConfiguration config() {
        return this.userConfig;
    }

    @Override
    public synchronized void flush(ReportAggregates reportAggregates) {
        super.flush(reportAggregates);
        if (this.getTestList().isEmpty()) {
            return;
        }
        this.loadUserConfig();
        try {
            Template template = this.getFreemarkerConfig().getTemplate(TEST_TEMPLATE_NAME);
            this.processTemplate(template, new File(String.valueOf(this.destination) + "index.html"));
            if (!this.getCategoryContextInfo().getTestAttributeTestContextList().isEmpty()) {
                template = this.getFreemarkerConfig().getTemplate(TAG_TEMPLATE_NAME);
                this.processTemplate(template, new File(String.valueOf(this.destination) + "tag.html"));
            }
            if (!this.getExceptionContextInfo().getExceptionTestContextList().isEmpty()) {
                template = this.getFreemarkerConfig().getTemplate(EXCEPTION_TEMPLATE_NAME);
                this.processTemplate(template, new File(String.valueOf(this.destination) + "exception.html"));
            }
            template = this.getFreemarkerConfig().getTemplate(DASHBOARD_TEMPLATE_NAME);
            this.processTemplate(template, new File(String.valueOf(this.destination) + "dashboard.html"));
        }
        catch (TemplateException | IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
        }
    }

    @Override
    public String getReporterName() {
        return REPORTER_NAME;
    }
}

