/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model.service;

import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.aventstack.extentreports.model.Test;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TestService {
    public static Boolean testHasAttributes(Test test) {
        return TestService.testHasAuthor(test) != false || TestService.testHasCategory(test) != false || TestService.testHasDevice(test) != false;
    }

    public static Boolean testHasAuthor(Test test) {
        return !test.getAuthorContext().isEmpty();
    }

    public static Boolean testHasCategory(Test test) {
        return !test.getCategoryContext().isEmpty();
    }

    public static Boolean testHasDevice(Test test) {
        return !test.getDeviceContext().isEmpty();
    }

    public static Boolean testHasException(Test test) {
        return !test.getExceptionInfoContext().isEmpty();
    }

    public static Boolean testHasChildren(Test test) {
        return !test.getNodeContext().isEmpty();
    }

    public static Boolean testHasLog(Test test) {
        return !test.getLogContext().isEmpty();
    }

    public static Boolean testHasScreenCapture(Test test) {
        return !test.getScreenCaptureContext().isEmpty();
    }

    public static Boolean isTestBehaviorDriven(Test test) {
        return test.getBddType() != null;
    }

    public static String getBehaviorDrivenTypeName(Class<? extends IGherkinFormatterModel> bddType) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = bddType.getMethod("getGherkinName", new Class[0]);
        Object o = method.invoke(null, (Object[])null);
        return o.toString();
    }

    public static String getBehaviorDrivenTypeName(Test test) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return TestService.getBehaviorDrivenTypeName(test.getBddType());
    }

    public static String getRunDuration(Test test) {
        long diff = test.getEndTime().getTime() - test.getStartTime().getTime();
        long secs = diff / 1000L;
        long millis = diff % 1000L;
        long mins = secs / 60L;
        long hours = mins / 60L;
        return hours + "h " + (mins %= 60L) + "m " + (secs %= 60L) + "s+" + millis + "ms";
    }

    public static Long getRunDurationMillis(Test test) {
        return test.getEndTime().getTime() - test.getStartTime().getTime();
    }
}

