/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.ReportAggregates;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.reporter.BasicFileReporter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class JsonFormatter
extends BasicFileReporter {
    public JsonFormatter(String path) {
        super(path);
    }

    public JsonFormatter(File file) {
        super(file);
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void flush(ReportAggregates reportAggregates) {
        super.flush(reportAggregates);
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        try (FileWriter writer = new FileWriter(this.getFilePath());){
            List<Test> list = reportAggregates.getTestList();
            gson.toJson(list, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getReporterName() {
        return "JSON";
    }
}

