/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter.configuration;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.offline.OfflineResxDelegate;
import com.aventstack.extentreports.reporter.ExtentSparkReporter;
import com.aventstack.extentreports.reporter.configuration.RichViewReporterConfiguration;
import com.aventstack.extentreports.utils.FileUtil;
import java.io.File;
import java.util.stream.Stream;

public class ExtentSparkReporterConfiguration
extends RichViewReporterConfiguration {
    public ExtentSparkReporterConfiguration(ExtentSparkReporter reporter) {
        super(reporter);
    }

    public void enableOfflineMode(Boolean offline) {
        this.getConfigurationStore().storeConfig("enableOfflineMode", String.valueOf(offline));
        this.getConfigurationStore().storeConfig("offlineDirectory", this.getReporter().getReporterName() + "/");
        if (offline.booleanValue()) {
            File f = this.getTargetDirectory(((ExtentSparkReporter)this.getReporter()).getFileFile());
            String s = "/";
            String resourcePackagePath = ExtentReports.class.getPackage().getName().replace(".", s);
            resourcePackagePath = resourcePackagePath + s + "offline" + s;
            String[] resx = this.combine(this.getJSFiles(), this.getCSSFiles(), this.getIconFiles(), this.getImgFiles());
            OfflineResxDelegate.saveOfflineResources(resourcePackagePath, resx, f.getAbsolutePath());
        }
    }

    private File getTargetDirectory(File f) {
        String dir;
        if (FileUtil.isDirectory(f).booleanValue()) {
            dir = f.getAbsolutePath().replace("\\", "/");
        } else {
            dir = f.getAbsolutePath().replace("\\", "/");
            dir = new File(dir).getParent();
        }
        dir = dir + "/" + this.getReporter().getReporterName();
        return new File(dir);
    }

    private String[] combine(String[] ... array) {
        String[] result = new String[]{};
        for (String[] arr : array) {
            result = (String[])Stream.of(result, arr).flatMap(Stream::of).toArray(String[]::new);
        }
        return result;
    }

    private String[] getJSFiles() {
        String commonsPath = "commons/js/";
        String reporterPath = this.getReporter().getReporterName() + "/js/";
        String[] files = new String[]{reporterPath + "spark-script.js", commonsPath + "jsontree.js"};
        return files;
    }

    private String[] getCSSFiles() {
        String stylesPath = "css/";
        String reporterPath = this.getReporter().getReporterName() + "/" + stylesPath;
        String[] files = new String[]{reporterPath + "spark-style.css"};
        return files;
    }

    private String[] getIconFiles() {
        String path = "commons/css/icons/";
        String iconDirPath = "fontawesome/";
        String[] files = new String[]{path + "font-awesome.min.css", path + iconDirPath + "fontawesome-webfont.eot", path + iconDirPath + "fontawesome-webfont.svg", path + iconDirPath + "fontawesome-webfont.ttf", path + iconDirPath + "fontawesome-webfont.woff", path + iconDirPath + "fontawesome-webfont.woff2", path + iconDirPath + "FontAwesome.otf"};
        return files;
    }

    private String[] getImgFiles() {
        String path = "commons/img/";
        String[] files = new String[]{path + "logo.png"};
        return files;
    }
}

