/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.convert;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.convert.JsonDeserializer;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class TestModelReportBuilder {
    public void createDomainFromJsonArchive(ExtentReports extent, File jsonFile) throws IOException {
        if (!jsonFile.exists()) {
            return;
        }
        Boolean configChanged = extent.getReportUsesManualConfiguration() == false;
        extent.setReportUsesManualConfiguration(true);
        List<Test> tests = JsonDeserializer.deserialize(jsonFile);
        for (Test test : tests) {
            try {
                if (test.getBehaviorDrivenTypeName() == null) {
                    this.createDomain(test, extent.createTest(test.getName(), test.getDescription()));
                    continue;
                }
                this.createDomain(test, extent.createTest(new GherkinKeyword(test.getBehaviorDrivenTypeName()), test.getName(), test.getDescription()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (configChanged.booleanValue()) {
            extent.setReportUsesManualConfiguration(false);
        }
    }

    public void createDomain(Test test, ExtentTest extentTest) throws ClassNotFoundException {
        extentTest.getModel().setStartTime(test.getStartTime());
        extentTest.getModel().setEndTime(test.getEndTime());
        extentTest.getModel().computeEndTimeFromChildren();
        for (Log log : test.getLogContext().getAll()) {
            if (log.getDetails() != null) {
                extentTest.log(log.getStatus(), log.getDetails());
            }
            if (log.getExceptionInfo() == null) continue;
            extentTest.log(log.getStatus(), log.getExceptionInfo());
        }
        test.getAuthorContext().getAll().forEach(x -> {
            ExtentTest extentTest2 = extentTest.assignAuthor(x.getName());
        });
        test.getCategoryContext().getAll().forEach(x -> {
            ExtentTest extentTest2 = extentTest.assignCategory(x.getName());
        });
        test.getDeviceContext().getAll().forEach(x -> {
            ExtentTest extentTest2 = extentTest.assignDevice(x.getName());
        });
        for (Test node : test.getNodeContext().getAll()) {
            ExtentTest extentNode = null;
            extentNode = node.getBehaviorDrivenTypeName() == null ? extentTest.createNode(node.getName(), node.getDescription()) : extentTest.createNode(new GherkinKeyword(node.getBehaviorDrivenTypeName()), node.getName(), node.getDescription());
            this.createDomain(node, extentNode);
        }
    }
}

