/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.configuration;

import com.aventstack.extentreports.configuration.ConfigurationStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationBuilder {
    private static final Logger logger = Logger.getLogger(ConfigurationBuilder.class.getName());
    private ConfigurationStore store = new ConfigurationStore();
    private InputStream stream;

    public ConfigurationBuilder(URL url) {
        try {
            this.stream = url.openStream();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, url.toString(), e);
        }
    }

    public ConfigurationBuilder(File file, Boolean silent) {
        try {
            if (silent.booleanValue() && !file.exists()) {
                return;
            }
            this.stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, file.getPath(), e);
        }
    }

    public ConfigurationStore getConfigurationStore() {
        if (this.stream == null) {
            return null;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(this.stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("configuration").item(0).getChildNodes();
            int ix = 0;
            while (ix < nodeList.getLength()) {
                Element el;
                Node node = nodeList.item(ix);
                Element element = el = node.getNodeType() == 1 ? (Element)node : null;
                if (el != null) {
                    String value = el.getTextContent();
                    value = el instanceof CharacterData ? ((CharacterData)((Object)el)).getData() : value;
                    this.store.storeConfig(el.getNodeName(), value);
                }
                ++ix;
            }
            return this.store;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.log(Level.SEVERE, "Failed to load external configuration", e);
            return null;
        }
    }
}

