/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.BaseEntity;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.ReportStats;
import com.aventstack.extentreports.model.SystemEnvInfo;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.context.NamedAttributeContextManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class Report
implements Serializable,
BaseEntity {
    private static final long serialVersionUID = -8667496631392333349L;
    private final Object obj = new Object();
    private Date startTime;
    private Date endTime;
    private Status status;
    private final transient ReportStats stats = new ReportStats();
    private final List<Test> testList = Collections.synchronizedList(new ArrayList());
    private final transient NamedAttributeContextManager<Author> authorCtx = new NamedAttributeContextManager();
    private final transient NamedAttributeContextManager<Category> categoryCtx = new NamedAttributeContextManager();
    private final transient NamedAttributeContextManager<Device> deviceCtx = new NamedAttributeContextManager();
    private final transient NamedAttributeContextManager<ExceptionInfo> exceptionInfoCtx = new NamedAttributeContextManager();
    private final List<String> logs = Collections.synchronizedList(new ArrayList());
    private final List<SystemEnvInfo> systemEnvInfo = new ArrayList<SystemEnvInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refresh() {
        this.authorCtx.getSet().forEach(x -> x.refresh());
        this.categoryCtx.getSet().forEach(x -> x.refresh());
        this.deviceCtx.getSet().forEach(x -> x.refresh());
        this.stats.update(this.testList);
        Object object = this.obj;
        synchronized (object) {
            this.setEndTime(Calendar.getInstance().getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void applyOverrideConf() {
        Date min = this.testList.stream().map(t -> t.getStartTime()).min(Date::compareTo).get();
        Date max = this.testList.stream().map(t -> t.getEndTime()).max(Date::compareTo).get();
        Object object = this.obj;
        synchronized (object) {
            this.setStartTime(min);
            this.setEndTime(max);
        }
    }

    public final boolean isBDD() {
        return !this.testList.isEmpty() && this.testList.stream().allMatch(Test::isBDD);
    }

    public final boolean anyTestHasStatus(Status status) {
        return this.testList.stream().anyMatch(x -> x.getStatus() == status);
    }

    public Optional<Test> findTest(List<Test> list, String name) {
        Iterator<Test> iterator;
        Optional<Test> test = list.stream().filter(x -> x.getName().equals(name)).findFirst();
        if (!test.isPresent() && (iterator = list.iterator()).hasNext()) {
            Test t = iterator.next();
            return this.findTest(t.getChildren(), name);
        }
        return test;
    }

    public List<ExceptionInfo> aggregateExceptions(List<Test> testList) {
        ArrayList<ExceptionInfo> list = new ArrayList<ExceptionInfo>();
        for (Test test : testList) {
            list.addAll(test.aggregateExceptions());
            if (test.getChildren().isEmpty()) continue;
            this.aggregateExceptions(test.getChildren());
        }
        return list;
    }

    public final long timeTaken() {
        return this.endTime.getTime() - this.startTime.getTime();
    }

    public final Status getStatus() {
        List<Status> list = this.testList.stream().map(x -> x.getStatus()).collect(Collectors.toList());
        Status s = Status.max(list);
        if (s == Status.SKIP && this.anyTestHasStatus(Status.PASS)) {
            s = Status.PASS;
        }
        return s;
    }

    @Generated
    private static Date $default$startTime() {
        return Calendar.getInstance().getTime();
    }

    @Generated
    private static Date $default$endTime() {
        return Calendar.getInstance().getTime();
    }

    @Generated
    private static Status $default$status() {
        return Status.PASS;
    }

    @Generated
    public static ReportBuilder builder() {
        return new ReportBuilder();
    }

    @Generated
    public Object getObj() {
        return this.obj;
    }

    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getEndTime() {
        return this.endTime;
    }

    @Generated
    public ReportStats getStats() {
        return this.stats;
    }

    @Generated
    public List<Test> getTestList() {
        return this.testList;
    }

    @Generated
    public NamedAttributeContextManager<Author> getAuthorCtx() {
        return this.authorCtx;
    }

    @Generated
    public NamedAttributeContextManager<Category> getCategoryCtx() {
        return this.categoryCtx;
    }

    @Generated
    public NamedAttributeContextManager<Device> getDeviceCtx() {
        return this.deviceCtx;
    }

    @Generated
    public NamedAttributeContextManager<ExceptionInfo> getExceptionInfoCtx() {
        return this.exceptionInfoCtx;
    }

    @Generated
    public List<String> getLogs() {
        return this.logs;
    }

    @Generated
    public List<SystemEnvInfo> getSystemEnvInfo() {
        return this.systemEnvInfo;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public Report(Date startTime, Date endTime, Status status) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.status = status;
    }

    @Generated
    public String toString() {
        return "Report(obj=" + this.getObj() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", status=" + (Object)((Object)this.getStatus()) + ", stats=" + this.getStats() + ", testList=" + this.getTestList() + ", authorCtx=" + this.getAuthorCtx() + ", categoryCtx=" + this.getCategoryCtx() + ", deviceCtx=" + this.getDeviceCtx() + ", exceptionInfoCtx=" + this.getExceptionInfoCtx() + ", logs=" + this.getLogs() + ", systemEnvInfo=" + this.getSystemEnvInfo() + ")";
    }

    @Generated
    public static class ReportBuilder {
        @Generated
        private boolean startTime$set;
        @Generated
        private Date startTime$value;
        @Generated
        private boolean endTime$set;
        @Generated
        private Date endTime$value;
        @Generated
        private boolean status$set;
        @Generated
        private Status status$value;

        @Generated
        ReportBuilder() {
        }

        @Generated
        public ReportBuilder startTime(Date startTime) {
            this.startTime$value = startTime;
            this.startTime$set = true;
            return this;
        }

        @Generated
        public ReportBuilder endTime(Date endTime) {
            this.endTime$value = endTime;
            this.endTime$set = true;
            return this;
        }

        @Generated
        public ReportBuilder status(Status status) {
            this.status$value = status;
            this.status$set = true;
            return this;
        }

        @Generated
        public Report build() {
            Date startTime$value = this.startTime$value;
            if (!this.startTime$set) {
                startTime$value = Report.$default$startTime();
            }
            Date endTime$value = this.endTime$value;
            if (!this.endTime$set) {
                endTime$value = Report.$default$endTime();
            }
            Status status$value = this.status$value;
            if (!this.status$set) {
                status$value = Report.$default$status();
            }
            return new Report(startTime$value, endTime$value, status$value);
        }

        @Generated
        public String toString() {
            return "Report.ReportBuilder(startTime$value=" + this.startTime$value + ", endTime$value=" + this.endTime$value + ", status$value=" + (Object)((Object)this.status$value) + ")";
        }
    }
}

