/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.aventstack.extentreports.gherkin.model.Scenario;
import com.aventstack.extentreports.gherkin.model.ScenarioOutline;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.BaseEntity;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.MetaDataStorable;
import com.aventstack.extentreports.model.RunResult;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.util.Assert;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Test
implements RunResult,
Serializable,
BaseEntity,
MetaDataStorable {
    private static final long serialVersionUID = -4896520724677957845L;
    private static final AtomicInteger atomicInt = new AtomicInteger(0);
    private final transient int id = atomicInt.incrementAndGet();
    private final transient StatusDeterminator determinator = new StatusDeterminator();
    private boolean useNaturalConf;
    private Date startTime;
    private Date endTime;
    private Status status;
    private Integer level;
    private boolean isLeaf;
    private String name;
    private String description;
    private transient Test parent;
    private Class<? extends IGherkinFormatterModel> bddType;
    private final Map<String, Object> infoMap = new HashMap<String, Object>();
    private final List<Test> children = Collections.synchronizedList(new ArrayList());
    private final List<Log> logs = Collections.synchronizedList(new ArrayList());
    private final List<Media> media = Collections.synchronizedList(new ArrayList());
    private final List<ExceptionInfo> exceptions = new ArrayList<ExceptionInfo>();
    private final Set<Author> authorSet = ConcurrentHashMap.newKeySet();
    private final Set<Category> categorySet = ConcurrentHashMap.newKeySet();
    private final Set<Device> deviceSet = ConcurrentHashMap.newKeySet();
    private final List<Log> generatedLog = Collections.synchronizedList(new ArrayList());

    public final void addChild(Test child) {
        Assert.notNull(child, "Node must not be null");
        child.setLevel(this.level + 1);
        child.setParent(this);
        child.setLeaf(true);
        this.isLeaf = false;
        if (!child.isBDD() || child.isBDD() && child.bddType == Scenario.class) {
            child.authorSet.addAll(this.authorSet);
            child.categorySet.addAll(this.categorySet);
            child.deviceSet.addAll(this.deviceSet);
        }
        this.end(child.getStatus());
        this.children.add(child);
    }

    private void end(Status evtStatus) {
        this.setStatus(Status.max(this.status, evtStatus));
        if (this.useNaturalConf) {
            this.propogateTime();
        }
    }

    private void propogateTime() {
        this.setEndTime(Calendar.getInstance().getTime());
        if (this.parent != null) {
            this.parent.propogateTime();
        }
    }

    public final void addLog(Log log) {
        this.addLog(log, this.logs);
    }

    public final void addGeneratedLog(Log log) {
        this.addLog(log, this.generatedLog);
    }

    private final void addLog(Log log, List<Log> list) {
        Assert.notNull(log, "Log must not be null");
        log.setSeq(list.size());
        list.add(log);
        this.end(log.getStatus());
        this.updateResult();
    }

    public final boolean isBDD() {
        return this.getBddType() != null;
    }

    public final boolean hasLog() {
        return !this.logs.isEmpty();
    }

    public final boolean hasAnyLog() {
        return !this.logs.isEmpty() || !this.generatedLog.isEmpty();
    }

    public final boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public final boolean hasAttributes() {
        return this.hasAuthor() || this.hasCategory() || this.hasDevice();
    }

    public final boolean hasAuthor() {
        return !this.authorSet.isEmpty();
    }

    public final boolean hasCategory() {
        return !this.categorySet.isEmpty();
    }

    public final boolean hasDevice() {
        return !this.deviceSet.isEmpty();
    }

    public final boolean hasException() {
        return !this.exceptions.isEmpty();
    }

    public final String getFullName() {
        Test test = this;
        StringBuilder sb = new StringBuilder(test.getName());
        while (test.getParent() != null) {
            if ((test = test.getParent()).isBDD() && test.getBddType() == ScenarioOutline.class) continue;
            sb.insert(0, test.getName() + ".");
        }
        return sb.toString();
    }

    public final void addMedia(Media m) {
        if (m != null && (m.getPath() != null || m.getResolvedPath() != null || ((ScreenCapture)m).getBase64() != null)) {
            this.media.add(m);
        }
        this.end(this.status);
    }

    public final boolean hasScreenCapture() {
        return !this.media.isEmpty() && this.media.stream().anyMatch(x -> x instanceof ScreenCapture);
    }

    public final long timeTaken() {
        return this.endTime.getTime() - this.startTime.getTime();
    }

    public final String timeTakenPretty() {
        Date date = new Date(this.timeTaken());
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String formatted = formatter.format(date);
        return formatted;
    }

    public List<ExceptionInfo> aggregateExceptions() {
        return this.logs.stream().filter(x -> x.getException() != null).map(x -> x.getException()).collect(Collectors.toList());
    }

    public final Test getAncestor() {
        Test test = this;
        while (test.getParent() != null) {
            test = test.getParent();
        }
        return test;
    }

    public final void updateResult() {
        this.determinator.computeTestStatus();
    }

    @Generated
    private static boolean $default$useNaturalConf() {
        return true;
    }

    @Generated
    private static Date $default$startTime() {
        return Calendar.getInstance().getTime();
    }

    @Generated
    private static Date $default$endTime() {
        return Calendar.getInstance().getTime();
    }

    @Generated
    private static Status $default$status() {
        return Status.PASS;
    }

    @Generated
    private static Integer $default$level() {
        return 0;
    }

    @Generated
    private static boolean $default$isLeaf() {
        return true;
    }

    @Generated
    public static TestBuilder builder() {
        return new TestBuilder();
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public StatusDeterminator getDeterminator() {
        return this.determinator;
    }

    @Generated
    public boolean isUseNaturalConf() {
        return this.useNaturalConf;
    }

    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public Integer getLevel() {
        return this.level;
    }

    @Generated
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Test getParent() {
        return this.parent;
    }

    @Generated
    public Class<? extends IGherkinFormatterModel> getBddType() {
        return this.bddType;
    }

    @Override
    @Generated
    public Map<String, Object> getInfoMap() {
        return this.infoMap;
    }

    @Generated
    public List<Test> getChildren() {
        return this.children;
    }

    @Generated
    public List<Log> getLogs() {
        return this.logs;
    }

    @Generated
    public List<Media> getMedia() {
        return this.media;
    }

    @Generated
    public List<ExceptionInfo> getExceptions() {
        return this.exceptions;
    }

    @Generated
    public Set<Author> getAuthorSet() {
        return this.authorSet;
    }

    @Generated
    public Set<Category> getCategorySet() {
        return this.categorySet;
    }

    @Generated
    public Set<Device> getDeviceSet() {
        return this.deviceSet;
    }

    @Generated
    public List<Log> getGeneratedLog() {
        return this.generatedLog;
    }

    @Generated
    public void setUseNaturalConf(boolean useNaturalConf) {
        this.useNaturalConf = useNaturalConf;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public void setLevel(Integer level) {
        this.level = level;
    }

    @Generated
    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setParent(Test parent) {
        this.parent = parent;
    }

    @Generated
    public void setBddType(Class<? extends IGherkinFormatterModel> bddType) {
        this.bddType = bddType;
    }

    @Generated
    public Test() {
        this.useNaturalConf = Test.$default$useNaturalConf();
        this.startTime = Test.$default$startTime();
        this.endTime = Test.$default$endTime();
        this.status = Test.$default$status();
        this.level = Test.$default$level();
        this.isLeaf = Test.$default$isLeaf();
    }

    @Generated
    public Test(boolean useNaturalConf, Date startTime, Date endTime, Status status, Integer level, boolean isLeaf, String name, String description, Test parent, Class<? extends IGherkinFormatterModel> bddType) {
        this.useNaturalConf = useNaturalConf;
        this.startTime = startTime;
        this.endTime = endTime;
        this.status = status;
        this.level = level;
        this.isLeaf = isLeaf;
        this.name = name;
        this.description = description;
        this.parent = parent;
        this.bddType = bddType;
    }

    @Generated
    public static class TestBuilder {
        @Generated
        private boolean useNaturalConf$set;
        @Generated
        private boolean useNaturalConf$value;
        @Generated
        private boolean startTime$set;
        @Generated
        private Date startTime$value;
        @Generated
        private boolean endTime$set;
        @Generated
        private Date endTime$value;
        @Generated
        private boolean status$set;
        @Generated
        private Status status$value;
        @Generated
        private boolean level$set;
        @Generated
        private Integer level$value;
        @Generated
        private boolean isLeaf$set;
        @Generated
        private boolean isLeaf$value;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private Test parent;
        @Generated
        private Class<? extends IGherkinFormatterModel> bddType;

        @Generated
        TestBuilder() {
        }

        @Generated
        public TestBuilder useNaturalConf(boolean useNaturalConf) {
            this.useNaturalConf$value = useNaturalConf;
            this.useNaturalConf$set = true;
            return this;
        }

        @Generated
        public TestBuilder startTime(Date startTime) {
            this.startTime$value = startTime;
            this.startTime$set = true;
            return this;
        }

        @Generated
        public TestBuilder endTime(Date endTime) {
            this.endTime$value = endTime;
            this.endTime$set = true;
            return this;
        }

        @Generated
        public TestBuilder status(Status status) {
            this.status$value = status;
            this.status$set = true;
            return this;
        }

        @Generated
        public TestBuilder level(Integer level) {
            this.level$value = level;
            this.level$set = true;
            return this;
        }

        @Generated
        public TestBuilder isLeaf(boolean isLeaf) {
            this.isLeaf$value = isLeaf;
            this.isLeaf$set = true;
            return this;
        }

        @Generated
        public TestBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public TestBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public TestBuilder parent(Test parent) {
            this.parent = parent;
            return this;
        }

        @Generated
        public TestBuilder bddType(Class<? extends IGherkinFormatterModel> bddType) {
            this.bddType = bddType;
            return this;
        }

        @Generated
        public Test build() {
            boolean useNaturalConf$value = this.useNaturalConf$value;
            if (!this.useNaturalConf$set) {
                useNaturalConf$value = Test.$default$useNaturalConf();
            }
            Date startTime$value = this.startTime$value;
            if (!this.startTime$set) {
                startTime$value = Test.$default$startTime();
            }
            Date endTime$value = this.endTime$value;
            if (!this.endTime$set) {
                endTime$value = Test.$default$endTime();
            }
            Status status$value = this.status$value;
            if (!this.status$set) {
                status$value = Test.$default$status();
            }
            Integer level$value = this.level$value;
            if (!this.level$set) {
                level$value = Test.$default$level();
            }
            boolean isLeaf$value = this.isLeaf$value;
            if (!this.isLeaf$set) {
                isLeaf$value = Test.$default$isLeaf();
            }
            return new Test(useNaturalConf$value, startTime$value, endTime$value, status$value, level$value, isLeaf$value, this.name, this.description, this.parent, this.bddType);
        }

        @Generated
        public String toString() {
            return "Test.TestBuilder(useNaturalConf$value=" + this.useNaturalConf$value + ", startTime$value=" + this.startTime$value + ", endTime$value=" + this.endTime$value + ", status$value=" + (Object)((Object)this.status$value) + ", level$value=" + this.level$value + ", isLeaf$value=" + this.isLeaf$value + ", name=" + this.name + ", description=" + this.description + ", parent=" + this.parent + ", bddType=" + this.bddType + ")";
        }
    }

    private class StatusDeterminator {
        private StatusDeterminator() {
        }

        public void computeTestStatus() {
            List<Test> leafList = this.getLeafList(Test.this);
            this.computeStatus(leafList);
        }

        private List<Test> getLeafList(Test test) {
            ArrayList<Test> testList = new ArrayList<Test>();
            if (test.isLeaf()) {
                testList.add(test);
            } else {
                for (Test t : test.getChildren()) {
                    if (t.isLeaf()) {
                        testList.add(t);
                        continue;
                    }
                    testList.addAll(this.getLeafList(t));
                }
            }
            return testList;
        }

        private void computeStatus(List<Test> testList) {
            testList.forEach(this::computeStatus);
        }

        private void computeStatus(Test t) {
            HashSet<Status> set = new HashSet<Status>();
            Iterator<Log> iter = new ArrayList<Log>(t.getLogs()).iterator();
            while (iter.hasNext()) {
                set.add(iter.next().getStatus());
            }
            set.add(t.getStatus());
            t.setStatus(Status.max(set));
            if (t.getParent() != null) {
                t.getParent().setStatus(Status.max(t.getStatus(), t.getParent().getStatus()));
                this.computeStatus(t.getParent());
            }
        }
    }
}

