/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.reporter.FileUtil;
import com.aventstack.extentreports.reporter.MediaStorage;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class HttpMediaManagerImplKlov
implements MediaStorage {
    private static final Logger logger = Logger.getLogger(HttpMediaManagerImplKlov.class.getName());
    private static final String ROUTE = "api/files";
    private String host;

    @Override
    public void init(String host) throws IOException {
        this.host = host;
        if (host.lastIndexOf(47) != host.length() - 1) {
            this.host = String.valueOf(host) + "/";
        }
    }

    @Override
    public void storeMedia(Media m) throws IOException {
        HttpResponse response;
        int responseCode;
        boolean isValid;
        if (m.getPath() == null) {
            return;
        }
        if (m instanceof ScreenCapture && ((ScreenCapture)m).getBase64() != null) {
            return;
        }
        File f = new File(m.getResolvedPath());
        if (!f.exists()) {
            throw new IOException("The system cannot find the file specified " + m.getPath());
        }
        HttpPost post = new HttpPost(String.valueOf(this.host) + ROUTE);
        post.addHeader("Connection", "keep-alive");
        post.addHeader("User-Agent", "Mozilla/5.0");
        post.addHeader("Accept", "application/json");
        String ext = FileUtil.getExtension(m.getPath());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("name", (ContentBody)new StringBody(String.valueOf(Calendar.getInstance().getTime().getTime()) + "." + ext, ContentType.TEXT_PLAIN));
        builder.addPart("id", (ContentBody)new StringBody(m.getInfoMap().get("KLOV_ID").toString(), ContentType.TEXT_PLAIN));
        builder.addPart("reportId", (ContentBody)new StringBody(m.getInfoMap().get("KLOV_REPORT_ID").toString(), ContentType.TEXT_PLAIN));
        builder.addPart("testId", (ContentBody)new StringBody(m.getInfoMap().get("KLOV_TEST_ID").toString(), ContentType.TEXT_PLAIN));
        builder.addPart("f", (ContentBody)new FileBody(new File(m.getResolvedPath())));
        post.setEntity(builder.build());
        String logId = m.getInfoMap().get("KLOV_LOG_ID") == null ? null : m.getInfoMap().get("KLOV_LOG_ID").toString();
        builder.addPart("logId", (ContentBody)new StringBody(logId, ContentType.TEXT_PLAIN));
        CloseableHttpClient client = null;
        if (this.host.toLowerCase().startsWith("https")) {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            try {
                sslContextBuilder.loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContextBuilder.build(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            }
            catch (Exception sslsf) {}
        } else {
            client = HttpClientBuilder.create().build();
        }
        if (!(isValid = this.isResponseValid(responseCode = (response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode()))) {
            logger.warning("Unable to upload file to server " + m.getPath());
        }
    }

    private boolean isResponseValid(int responseCode) {
        return 200 <= responseCode && responseCode <= 399;
    }
}

