/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.AttribStatusDist;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.MetaDataStorable;
import com.aventstack.extentreports.model.NamedAttribute;
import com.aventstack.extentreports.model.Report;
import com.aventstack.extentreports.model.ReportStats;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.SystemEnvInfo;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.context.NamedAttributeContext;
import com.aventstack.extentreports.model.context.NamedAttributeContextManager;
import com.aventstack.extentreports.observer.EntityObserver;
import com.aventstack.extentreports.observer.entity.AttributeEntity;
import com.aventstack.extentreports.observer.entity.LogEntity;
import com.aventstack.extentreports.observer.entity.MediaEntity;
import com.aventstack.extentreports.observer.entity.ObservedEntity;
import com.aventstack.extentreports.observer.entity.ReportEntity;
import com.aventstack.extentreports.observer.entity.TestEntity;
import com.aventstack.extentreports.reporter.AbstractReporter;
import com.aventstack.extentreports.reporter.IntUtil;
import com.aventstack.extentreports.reporter.KlovMedia;
import com.aventstack.extentreports.reporter.KlovMediaStorageHandler;
import com.aventstack.extentreports.reporter.MongoUtil;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class ExtentKlovReporter
extends AbstractReporter
implements EntityObserver<ObservedEntity> {
    public static final String ID_KEY = "KLOV_ID";
    public static final String REPORT_ID_KEY = "KLOV_REPORT_ID";
    public static final String LOG_ID_KEY = "KLOV_LOG_ID";
    public static final String TEST_ID_KEY = "KLOV_TEST_ID";
    private static final String DEFAULT_PROJECT_NAME_PROP = "klov.project.name";
    private static final String DEFAULT_REPORT_NAME_PROP = "klov.report.name";
    private static final String DEFAULT_MONGODB_HOST_PROP = "mongodb.host";
    private static final String DEFAULT_MONGODB_PORT_PROP = "mongodb.port";
    private static final String DEFAULT_MONGODB_URI_PROP = "mongodb.uri";
    private static final String DEFAULT_DATABASE_NAME_PROP = "database.name";
    private static final String DEFAULT_KLOV_HOST_PROP = "klov.host";
    private static final String DEFAULT_KLOV_PORT_PROP = "klov.port";
    private static final String DEFAULT_PROJECT_NAME = "Default";
    private static final String DB_NAME = "klov";
    private final AtomicBoolean initiated = new AtomicBoolean();
    private String databaseName = "klov";
    private String url;
    private Boolean appendExisting = false;
    private NamedAttributeContextManager<Category> categoryContext;
    private NamedAttributeContextManager<Author> authorContext;
    private NamedAttributeContextManager<Device> deviceContext;
    private Map<String, ObjectId> categoryNameObjectIdCollection = new HashMap<String, ObjectId>();
    private Map<String, ObjectId> authorNameObjectIdCollection = new HashMap<String, ObjectId>();
    private Map<String, ObjectId> deviceNameObjectIdCollection = new HashMap<String, ObjectId>();
    private Map<String, ObjectId> exceptionNameObjectIdCollection = new HashMap<String, ObjectId>();
    private KlovMediaStorageHandler mediaStorageHandler;
    private ObjectId reportId;
    private String reportName;
    private long reportSeq;
    private ObjectId projectId;
    private String projectName;
    private MongoClient mongoClient;
    private MongoCollection<Document> projectCollection;
    private MongoCollection<Document> reportCollection;
    private MongoCollection<Document> testCollection;
    private MongoCollection<Document> logCollection;
    private MongoCollection<Document> exceptionCollection;
    private MongoCollection<Document> mediaCollection;
    private MongoCollection<Document> categoryCollection;
    private MongoCollection<Document> authorCollection;
    private MongoCollection<Document> deviceCollection;
    private MongoCollection<Document> environmentCollection;

    public ExtentKlovReporter() {
    }

    public ExtentKlovReporter(String projectName, String reportName) {
        this();
        this.projectName = projectName;
        this.reportName = reportName;
    }

    public ExtentKlovReporter(String projectName) {
        this(projectName, null);
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public ExtentKlovReporter initMongoDbConnection(String host) {
        this.mongoClient = new MongoClient(host, 27017);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(String host, MongoClientOptions options) {
        this.mongoClient = new MongoClient(host, options);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(String host, int port) {
        this.mongoClient = new MongoClient(host, port);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(MongoClientURI uri) {
        this.mongoClient = new MongoClient(uri);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(ServerAddress addr) {
        this.mongoClient = new MongoClient(addr);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(List<ServerAddress> seeds) {
        this.mongoClient = new MongoClient(seeds);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(List<ServerAddress> seeds, MongoClientOptions options) {
        this.mongoClient = new MongoClient(seeds, options);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(ServerAddress addr, MongoClientOptions options) {
        this.mongoClient = new MongoClient(addr, options);
        return this;
    }

    public ExtentKlovReporter initKlovServerConnection(String url) {
        this.url = url;
        return this;
    }

    public ExtentKlovReporter setDatabaseName(String name) {
        this.databaseName = name;
        return this;
    }

    public ExtentKlovReporter initWithDefaultSettings() {
        return this.initMongoDbConnection("localhost", 27017).initKlovServerConnection("http://localhost");
    }

    public void loadInitializationParams(InputStream is) {
        try {
            Properties props = this.loadProperties(is);
            this.loadInitializationParams(props);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Properties loadProperties(InputStream is) throws IOException {
        Properties properties = new Properties();
        properties.load(is);
        return properties;
    }

    private void loadInitializationParams(Properties props) {
        int mongoPortInt;
        String databaseName = props.getProperty(DEFAULT_DATABASE_NAME_PROP);
        if (databaseName != null && !databaseName.isEmpty()) {
            this.databaseName = databaseName;
        }
        String mongoUri = props.getProperty(DEFAULT_MONGODB_URI_PROP);
        String mongoHost = props.getProperty(DEFAULT_MONGODB_HOST_PROP);
        String mongoPort = props.getProperty(DEFAULT_MONGODB_PORT_PROP);
        int n = mongoPortInt = IntUtil.tryParseInt(mongoPort) ? Integer.valueOf(mongoPort) : -1;
        if (mongoHost != null && mongoPortInt != -1) {
            this.initMongoDbConnection(mongoHost, mongoPortInt);
        } else if (mongoHost != null) {
            this.initMongoDbConnection(mongoHost);
        } else if (mongoUri != null) {
            this.initMongoDbConnection(new MongoClientURI(mongoUri));
        } else {
            throw new IllegalStateException("Mongo connection params have not been supplied.");
        }
        String projectName = props.getProperty(DEFAULT_PROJECT_NAME_PROP);
        this.projectName = projectName == null || projectName.isEmpty() ? this.projectName : projectName;
        String reportName = props.getProperty(DEFAULT_REPORT_NAME_PROP);
        this.reportName = reportName = reportName == null || reportName.isEmpty() ? this.reportName : reportName;
        String klovHost = props.getProperty(DEFAULT_KLOV_HOST_PROP);
        String klovPort = props.getProperty(DEFAULT_KLOV_PORT_PROP);
        if (klovHost != null && klovPort != null) {
            String uri = klovHost + ":" + klovPort;
            this.initKlovServerConnection(uri);
        } else if (klovHost != null) {
            this.initKlovServerConnection(klovHost);
        }
    }

    private void initCollections(MongoDatabase db) {
        this.projectCollection = db.getCollection("project");
        this.reportCollection = db.getCollection("report");
        this.testCollection = db.getCollection("test");
        this.logCollection = db.getCollection("log");
        this.exceptionCollection = db.getCollection("exception");
        this.mediaCollection = db.getCollection("media");
        this.categoryCollection = db.getCollection("category");
        this.authorCollection = db.getCollection("author");
        this.deviceCollection = db.getCollection("device");
        this.environmentCollection = db.getCollection("environment");
    }

    private void setupProject() {
        String projectName = this.projectName == null || this.projectName.isEmpty() ? DEFAULT_PROJECT_NAME : this.projectName;
        Document doc = new Document("name", (Object)projectName);
        Document project = (Document)this.projectCollection.find((Bson)doc).first();
        if (project != null) {
            this.projectId = project.getObjectId((Object)"_id");
        } else {
            doc.append("createdAt", (Object)Calendar.getInstance().getTime());
            this.projectCollection.insertOne((Object)doc);
            this.projectId = MongoUtil.getId(doc);
        }
        this.setupReport(projectName);
    }

    private void setupReport(String projectName) {
        FindIterable iterable;
        Document report;
        String reportName;
        this.reportName = reportName = this.reportName == null || this.reportName.isEmpty() ? "Build " + Calendar.getInstance().getTimeInMillis() : this.reportName;
        Document doc = new Document("name", (Object)reportName).append("project", (Object)this.projectId).append("projectName", (Object)projectName);
        if (this.appendExisting.booleanValue() && (report = (Document)(iterable = this.reportCollection.find((Bson)doc)).first()) != null) {
            this.reportId = report.getObjectId((Object)"_id");
            return;
        }
        this.reportSeq = this.reportCollection.count((Bson)new Document("project", (Object)this.projectId)) + 1L;
        doc.append("startTime", (Object)Calendar.getInstance().getTime()).append("seq", (Object)this.reportSeq);
        this.reportCollection.insertOne((Object)doc);
        this.reportId = MongoUtil.getId(doc);
    }

    public synchronized void flush(ReportEntity entity) {
        Set set;
        Report report = entity.getReport();
        List testList = report.getTestList();
        if (testList == null || testList.isEmpty()) {
            return;
        }
        ReportStats stats = report.getStats();
        Document doc = new Document("endTime", (Object)report.getEndTime()).append("duration", (Object)report.timeTaken()).append("status", (Object)report.getStatus().toLower()).append("parentLength", (Object)stats.sumStat(stats.getParent())).append("passParentLength", stats.getParent().get(Status.PASS)).append("failParentLength", stats.getParent().get(Status.FAIL)).append("warningParentLength", stats.getParent().get(Status.WARNING)).append("skipParentLength", stats.getParent().get(Status.SKIP)).append("childLength", (Object)stats.sumStat(stats.getChild())).append("passChildLength", stats.getChild().get(Status.PASS)).append("failChildLength", stats.getChild().get(Status.FAIL)).append("warningChildLength", stats.getChild().get(Status.WARNING)).append("skipChildLength", stats.getChild().get(Status.SKIP)).append("grandChildLength", (Object)stats.sumStat(stats.getGrandchild())).append("passGrandChildLength", stats.getGrandchild().get(Status.PASS)).append("failGrandChildLength", stats.getGrandchild().get(Status.FAIL)).append("warningGrandChildLength", stats.getGrandchild().get(Status.WARNING)).append("skipGrandChildLength", stats.getGrandchild().get(Status.SKIP)).append("analysisStrategy", (Object)stats.getAnalysisStrategy().toString()).append("bdd", (Object)((Test)testList.get(0)).isBDD());
        this.authorContext = report.getAuthorCtx();
        this.categoryContext = report.getCategoryCtx();
        this.deviceContext = report.getDeviceCtx();
        Set<String> authorNameList = this.getCollectionKeys(this.authorNameObjectIdCollection);
        Set<String> categoryNameList = this.getCollectionKeys(this.categoryNameObjectIdCollection);
        Set<String> deviceNameList = this.getCollectionKeys(this.deviceNameObjectIdCollection);
        Set<String> exceptionNameList = this.getCollectionKeys(this.exceptionNameObjectIdCollection);
        if (authorNameList != null) {
            doc.append("authorNameList", authorNameList);
            set = report.getAuthorCtx().getSet().stream().map(x -> new AttribStatusDist(x)).collect(Collectors.toSet());
            doc.append("authorInfo", set);
        }
        if (categoryNameList != null) {
            doc.append("categoryNameList", categoryNameList);
            set = report.getCategoryCtx().getSet().stream().map(x -> new AttribStatusDist(x)).collect(Collectors.toSet());
            doc.append("categoryInfo", set);
        }
        if (deviceNameList != null && !deviceNameList.isEmpty()) {
            doc.append("deviceNameList", deviceNameList);
            set = report.getDeviceCtx().getSet().stream().map(x -> new AttribStatusDist(x)).collect(Collectors.toSet());
            doc.append("deviceInfo", set);
        }
        if (exceptionNameList != null) {
            doc.append("exceptions", exceptionNameList);
        }
        this.reportCollection.updateOne((Bson)new Document("_id", (Object)this.reportId), (Bson)new Document("$set", (Object)doc));
        this.insertUpdateSystemAttribute(report);
    }

    private void insertUpdateSystemAttribute(Report report) {
        List sysEnvInfoList = report.getSystemEnvInfo();
        for (SystemEnvInfo attr : sysEnvInfoList) {
            Document doc = new Document("project", (Object)this.projectId).append("report", (Object)this.reportId).append("name", (Object)attr.getName());
            Document envSingle = (Document)this.environmentCollection.find((Bson)doc).first();
            if (envSingle == null) {
                doc.append("value", (Object)attr.getValue());
                this.environmentCollection.insertOne((Object)doc);
                continue;
            }
            ObjectId id = envSingle.getObjectId((Object)"_id");
            doc = new Document("_id", (Object)id).append("value", (Object)attr.getValue());
            this.environmentCollection.updateOne((Bson)new Document("_id", (Object)id), (Bson)new Document("$set", (Object)doc));
        }
    }

    private Set<String> getCollectionKeys(Map<String, ObjectId> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return collection.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<ObjectId> getCollectionValues(Map<String, ObjectId> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return collection.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    private void updateTestDesc(Test test) {
        Document doc = new Document("description", (Object)test.getDescription());
        this.testCollection.updateOne((Bson)new Document("_id", test.getInfoMap().get(ID_KEY)), (Bson)new Document("$set", (Object)doc));
    }

    private void updateTestChildrenCount(Test test) {
        Document doc = new Document("childNodesLength", (Object)test.getChildren().size());
        this.testCollection.updateOne((Bson)new Document("_id", test.getInfoMap().get(ID_KEY)), (Bson)new Document("$set", (Object)doc));
    }

    public Observer<AttributeEntity> getAttributesObserver() {
        return new Observer<AttributeEntity>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(AttributeEntity value) {
                if (value.getAuthor() != null) {
                    ExtentKlovReporter.this.assignAttribute(value.getTest(), (NamedAttribute)value.getAuthor(), ExtentKlovReporter.this.authorNameObjectIdCollection, (MongoCollection<Document>)ExtentKlovReporter.this.authorCollection, ExtentKlovReporter.this.authorContext);
                }
                if (value.getCategory() != null) {
                    ExtentKlovReporter.this.assignAttribute(value.getTest(), (NamedAttribute)value.getCategory(), ExtentKlovReporter.this.categoryNameObjectIdCollection, (MongoCollection<Document>)ExtentKlovReporter.this.categoryCollection, ExtentKlovReporter.this.categoryContext);
                }
                if (value.getDevice() != null) {
                    ExtentKlovReporter.this.assignAttribute(value.getTest(), (NamedAttribute)value.getDevice(), ExtentKlovReporter.this.deviceNameObjectIdCollection, (MongoCollection<Document>)ExtentKlovReporter.this.deviceCollection, ExtentKlovReporter.this.deviceContext);
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        };
    }

    public <T extends NamedAttribute> void assignAttribute(Test test, NamedAttribute attribute, Map<String, ObjectId> attrObjectIdCollection, MongoCollection<Document> mongoCollection, NamedAttributeContextManager<T> attributeContext) {
        if (!attrObjectIdCollection.containsKey(attribute.getName())) {
            Document doc = new Document("report", (Object)this.reportId).append("project", (Object)this.projectId).append("name", (Object)attribute.getName());
            FindIterable iterable = mongoCollection.find((Bson)doc);
            Document docAttribute = (Document)iterable.first();
            if (docAttribute != null) {
                attrObjectIdCollection.put(attribute.getName(), docAttribute.getObjectId((Object)"_id"));
            } else {
                doc = new Document("testIdList", Arrays.asList(test.getInfoMap().get(ID_KEY))).append("testNameList", Arrays.asList(test.getName())).append("testLength", (Object)1).append("project", (Object)this.projectId).append("report", (Object)this.reportId).append("name", (Object)attribute.getName()).append("timeTaken", (Object)0L);
                mongoCollection.insertOne((Object)doc);
                ObjectId categoryId = MongoUtil.getId(doc);
                attrObjectIdCollection.put(attribute.getName(), categoryId);
            }
        } else {
            Optional<NamedAttributeContext> context;
            ObjectId id = attrObjectIdCollection.get(attribute.getName());
            int testLength = 1;
            if (attributeContext != null && (context = attributeContext.getSet().stream().filter(x -> x.getAttr().getName().equals(attribute.getName())).findFirst()).isPresent()) {
                testLength = context.get().size() + 1;
            }
            mongoCollection.updateOne((Bson)new Document("_id", (Object)id), (Bson)new Document("$push", (Object)new Document("testIdList", test.getInfoMap().get(ID_KEY)).append("testNameList", (Object)test.getName())));
            mongoCollection.updateOne((Bson)new Document("_id", (Object)id), (Bson)new Document("$set", (Object)new Document("testLength", (Object)testLength)));
        }
    }

    public Observer<LogEntity> getLogObserver() {
        return new Observer<LogEntity>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(LogEntity value) {
                ExtentKlovReporter.this.onLogAdded(value.getTest(), value.getLog());
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        };
    }

    public synchronized void onLogAdded(Test test, Log log) {
        Document doc = new Document("test", test.getInfoMap().get(ID_KEY)).append("project", (Object)this.projectId).append("report", (Object)this.reportId).append("testName", (Object)test.getName()).append("sequence", (Object)log.getSeq()).append("status", (Object)log.getStatus().toLower()).append("timestamp", (Object)log.getTimestamp()).append("mediaCount", (Object)(log.hasMedia() ? 1 : 0)).append("details", (Object)log.getDetails());
        if (log.hasException()) {
            doc.append("exception", (Object)log.getException().getName()).append("stacktrace", (Object)log.getException().getStackTrace());
        }
        if (log.hasMedia() && ((ScreenCapture)log.getMedia()).getBase64() != null) {
            doc.append("details", (Object)(log.getDetails() + ((ScreenCapture)log.getMedia()).getBase64()));
        }
        this.logCollection.insertOne((Object)doc);
        ObjectId logId = MongoUtil.getId(doc);
        log.getInfoMap().put(ID_KEY, logId);
        for (ExceptionInfo ex : test.getExceptions()) {
            doc = new Document("report", (Object)this.reportId).append("project", (Object)this.projectId).append("name", (Object)ex.getName());
            FindIterable iterable = this.exceptionCollection.find((Bson)doc);
            Document docException = (Document)iterable.first();
            if (!this.exceptionNameObjectIdCollection.containsKey(ex.getName())) {
                if (docException != null) {
                    this.exceptionNameObjectIdCollection.put(ex.getName(), docException.getObjectId((Object)"_id"));
                } else {
                    doc = new Document("project", (Object)this.projectId).append("report", (Object)this.reportId).append("name", (Object)ex.getName()).append("stacktrace", (Object)ex.getStackTrace()).append("testCount", (Object)0);
                    this.exceptionCollection.insertOne((Object)doc);
                    ObjectId exceptionId = MongoUtil.getId(doc);
                    docException = (Document)this.exceptionCollection.find((Bson)new Document("_id", (Object)exceptionId)).first();
                    this.exceptionNameObjectIdCollection.put(ex.getName(), exceptionId);
                }
            }
            Integer testCount = (Integer)docException.get((Object)"testCount") + 1;
            doc = new Document("testCount", (Object)testCount);
            this.exceptionCollection.updateOne((Bson)new Document("_id", (Object)docException.getObjectId((Object)"_id")), (Bson)new Document("$set", (Object)doc));
            doc = new Document("exception", (Object)this.exceptionNameObjectIdCollection.get(ex.getName())).append("exceptionName", (Object)ex.getName());
            this.testCollection.updateOne((Bson)new Document("_id", test.getInfoMap().get(ID_KEY)), (Bson)new Document("$set", (Object)doc));
            this.updateTestDesc(test);
        }
        this.endTestRecursive(test);
    }

    private void endTestRecursive(Test test) {
        Document doc = new Document("status", (Object)test.getStatus().toLower()).append("endTime", (Object)test.getEndTime()).append("duration", (Object)test.timeTaken()).append("leaf", (Object)test.isLeaf()).append("mediaCount", (Object)(!test.getMedia().isEmpty() ? test.getMedia().size() : 0)).append("childNodesLength", (Object)(test.hasChildren() ? test.getChildren().size() : 0)).append("logCount", (Object)(test.hasAnyLog() ? test.getLogs().size() + test.getGeneratedLog().size() : 0)).append("categorized", (Object)test.hasAttributes()).append("description", (Object)test.getDescription());
        if (test.hasCategory()) {
            List categoryNameList = test.getCategorySet().stream().map(NamedAttribute::getName).collect(Collectors.toList());
            doc.append("categoryNameList", categoryNameList);
        }
        if (test.hasDevice()) {
            List deviceNameList = test.getDeviceSet().stream().map(NamedAttribute::getName).collect(Collectors.toList());
            doc.append("deviceNameList", deviceNameList);
        }
        if (test.hasAuthor()) {
            List authorNameList = test.getAuthorSet().stream().map(NamedAttribute::getName).collect(Collectors.toList());
            doc.append("authorNameList", authorNameList);
        }
        this.testCollection.updateOne((Bson)new Document("_id", test.getInfoMap().get(ID_KEY)), (Bson)new Document("$set", (Object)doc));
        if (test.getLevel() > 0) {
            this.endTestRecursive(test.getParent());
        }
    }

    public Observer<MediaEntity> getMediaObserver() {
        return new Observer<MediaEntity>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(MediaEntity value) {
                try {
                    if (value.getLog() != null) {
                        ExtentKlovReporter.this.onScreenCaptureAdded(value.getLog(), value.getTest(), (ScreenCapture)value.getMedia());
                    } else if (value.getTest() != null) {
                        ExtentKlovReporter.this.onScreenCaptureAdded(value.getTest(), (ScreenCapture)value.getMedia());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        };
    }

    public void onScreenCaptureAdded(Test test, ScreenCapture screenCapture) throws IOException {
        screenCapture.getInfoMap().put(TEST_ID_KEY, test.getInfoMap().get(ID_KEY));
        this.saveScreenCapture((MetaDataStorable)test, screenCapture);
    }

    public void onScreenCaptureAdded(Log log, Test test, ScreenCapture screenCapture) throws IOException {
        screenCapture.getInfoMap().put(LOG_ID_KEY, log.getInfoMap().get(ID_KEY));
        screenCapture.getInfoMap().put(TEST_ID_KEY, test.getInfoMap().get(ID_KEY));
        this.logCollection.updateOne((Bson)new Document("_id", log.getInfoMap().get(ID_KEY)), (Bson)new Document("$set", (Object)new Document("mediaCount", (Object)1)));
        this.saveScreenCapture((MetaDataStorable)log, screenCapture);
    }

    private void saveScreenCapture(MetaDataStorable store, ScreenCapture screenCapture) throws IOException {
        if (this.mediaStorageHandler == null) {
            KlovMedia klovMedia = new KlovMedia(this.projectId, this.reportId, this.mediaCollection);
            this.mediaStorageHandler = new KlovMediaStorageHandler(this.url, klovMedia);
        }
        this.mediaStorageHandler.saveScreenCapture(store, screenCapture);
    }

    public Observer<ReportEntity> getReportObserver() {
        return new Observer<ReportEntity>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(ReportEntity value) {
                ExtentKlovReporter.this.flush(value);
            }

            public void onError(Throwable e) {
                ExtentKlovReporter.this.mongoClient.close();
            }

            public void onComplete() {
                ExtentKlovReporter.this.mongoClient.close();
            }
        };
    }

    public Observer<TestEntity> getTestObserver() {
        return new Observer<TestEntity>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(TestEntity value) {
                if (!ExtentKlovReporter.this.initiated.get()) {
                    ExtentKlovReporter.this.start();
                    ExtentKlovReporter.this.initiated.compareAndSet(false, true);
                }
                if (!value.getRemoved().booleanValue()) {
                    ExtentKlovReporter.this.onTestStarted(value.getTest());
                } else {
                    ExtentKlovReporter.this.onTestRemoved(value.getTest());
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        };
    }

    private final void start() {
        CodecRegistry pojoCodecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClient.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()})});
        MongoDatabase db = this.mongoClient.getDatabase(this.databaseName).withCodecRegistry(pojoCodecRegistry);
        this.initCollections(db);
        this.setupProject();
    }

    private void onTestStarted(Test test) {
        Document doc = new Document("project", (Object)this.projectId).append("report", (Object)this.reportId).append("reportName", (Object)this.reportName).append("reportSeq", (Object)this.reportSeq).append("level", (Object)test.getLevel()).append("name", (Object)test.getName()).append("status", (Object)test.getStatus().toLower()).append("description", (Object)test.getDescription()).append("startTime", (Object)test.getStartTime()).append("endTime", (Object)test.getEndTime()).append("bdd", (Object)test.isBDD()).append("leaf", (Object)test.isLeaf()).append("childNodesLength", (Object)test.getChildren().size()).append("mediaCount", (Object)0).append("childNodesLength", (Object)0).append("logCount", (Object)0);
        if (test.isBDD()) {
            doc.append("bddType", (Object)test.getBddType().getSimpleName());
        }
        if (test.getParent() != null) {
            doc.append("parent", test.getParent().getInfoMap().get(ID_KEY)).append("parentName", (Object)test.getParent().getName());
            this.updateTestChildrenCount(test.getParent());
            this.updateTestDesc(test.getParent());
        }
        this.testCollection.insertOne((Object)doc);
        ObjectId testId = MongoUtil.getId(doc);
        test.getInfoMap().put(ID_KEY, testId);
    }

    private void onTestRemoved(Test test) {
        Document doc = new Document("_id", test.getInfoMap().get(ID_KEY));
        this.testCollection.deleteOne((Bson)doc);
        test.getLogs().forEach(this::removeLog);
        if (test.hasAnyLog()) {
            doc = new Document("test", test.getInfoMap().get(ID_KEY));
            this.logCollection.deleteMany((Bson)doc);
        }
        if (test.hasAttributes()) {
            this.removeFromAttributes(test);
        }
        if (test.hasChildren()) {
            test.getChildren().forEach(this::onTestRemoved);
        }
    }

    private void removeLog(Log log) {
        Document doc = new Document("_id", log.getInfoMap().get(ID_KEY));
        this.logCollection.deleteOne((Bson)doc);
        if (log.hasMedia()) {
            this.removeMedia(log.getMedia());
        }
    }

    private void removeMedia(Media m) {
        Document doc = new Document("_id", m.getInfoMap().get(ID_KEY));
        this.mediaCollection.deleteOne((Bson)doc);
    }

    private void removeFromAttributes(Test t) {
        Document update;
        Document match;
        for (Author x : t.getAuthorSet()) {
            match = new Document("_id", (Object)this.authorNameObjectIdCollection.get(x.getName()));
            update = new Document("testIdList", t.getInfoMap().get(ID_KEY));
            this.authorCollection.updateOne((Bson)match, (Bson)new BasicDBObject("$pull", (Object)update));
        }
        for (Author x : t.getCategorySet()) {
            match = new Document("_id", (Object)this.categoryNameObjectIdCollection.get(x.getName()));
            update = new Document("testIdList", t.getInfoMap().get(ID_KEY));
            this.categoryCollection.updateOne((Bson)match, (Bson)new BasicDBObject("$pull", (Object)update));
        }
        for (Author x : t.getDeviceSet()) {
            match = new Document("_id", (Object)this.deviceNameObjectIdCollection.get(x.getName()));
            update = new Document("testIdList", t.getInfoMap().get(ID_KEY));
            this.deviceCollection.updateOne((Bson)match, (Bson)new BasicDBObject("$pull", (Object)update));
        }
    }

    public MongoClient mongoClient() {
        return this.mongoClient;
    }

    public String uri() {
        if (this.projectName == null || this.projectName.isEmpty() || this.reportId == null) {
            return "";
        }
        return "projects/" + this.projectName + "/launches/" + this.reportId.toString() + "/tests";
    }

    static {
        Logger mongoLogger = Logger.getLogger("org.mongodb.driver");
        mongoLogger.setLevel(Level.SEVERE);
    }
}

