/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.configuration;

import com.avides.spring.rabbit.configuration.IsSpringRabbitEnabled;
import com.avides.spring.rabbit.configuration.creator.CustomConnectionFactoryCreator;
import com.avides.spring.rabbit.configuration.creator.DlxQueueCreator;
import com.avides.spring.rabbit.configuration.creator.ListenerCreator;
import com.avides.spring.rabbit.configuration.creator.QueueCreator;
import com.avides.spring.rabbit.configuration.creator.RabbitAdminCreator;
import com.avides.spring.rabbit.configuration.creator.RabbitTemplateCreator;
import com.avides.spring.rabbit.configuration.domain.BeanReferenceConnectionFactoryProperties;
import com.avides.spring.rabbit.configuration.domain.CustomConnectionFactoryProperties;
import com.avides.spring.rabbit.configuration.domain.ExchangeProperties;
import com.avides.spring.rabbit.configuration.domain.ListenerProperties;
import com.avides.spring.rabbit.configuration.domain.MessageConverterProperties;
import com.avides.spring.rabbit.configuration.domain.QueueProperties;
import com.avides.spring.rabbit.configuration.domain.RabbitAdminProperties;
import com.avides.spring.rabbit.configuration.domain.RabbitTemplateProperties;
import com.avides.spring.rabbit.configuration.provider.ConnectionFactoryProvider;
import com.avides.spring.rabbit.configuration.util.DefaultValueResolver;
import com.avides.spring.rabbit.configuration.util.MessagePostProcessorUtils;
import com.avides.spring.rabbit.listener.container.DefaultMessageListenerContainer;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@Conditional(value={IsSpringRabbitEnabled.class})
@Configuration
@ConfigurationProperties(prefix="spring.rabbitmq")
public class SpringRabbitAutoConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SpringRabbitAutoConfiguration.class);
    private static final String CONNECTION_FACTORY_BEAN_NAME = "springRabbitConnectionFactory";
    @Autowired(required=false)
    private ConnectionFactory connectionFactory;
    @Autowired(required=false)
    private RabbitProperties rabbitProperties;
    @Autowired
    private MeterRegistry meterRegistry;
    @Autowired
    private GenericApplicationContext applicationContext;
    @Autowired
    private List<MessageConverter> existingMessageConverterList;
    @Autowired
    private List<MessagePostProcessor> messagePostProcessors;
    @NotNull
    @Valid
    @NestedConfigurationProperty
    private List<QueueProperties> queues = new ArrayList<QueueProperties>();
    @NotNull
    @Valid
    @NestedConfigurationProperty
    private List<RabbitTemplateProperties> outbounds = new ArrayList<RabbitTemplateProperties>();
    @Valid
    @NestedConfigurationProperty
    private List<CustomConnectionFactoryProperties> connections;
    @Valid
    @NestedConfigurationProperty
    private ExchangeProperties exchange;
    @Valid
    @NestedConfigurationProperty
    private MessageConverterProperties messageConverter;
    @NotNull
    @Min(value=1L)
    private @NotNull @Min(value=1L) Integer prefetchCount = 500;
    @NotNull
    @Min(value=1L)
    private @NotNull @Min(value=1L) Integer maxConcurrentConsumers = 1;
    @Range(min=1L, max=65535L)
    private @Range(min=1L, max=65535L) int apiPort = 15672;

    public void afterPropertiesSet() throws Exception {
        this.configureConnectionFactories();
        this.configureQueues();
        this.configureRabbitTemplates();
    }

    private void configureConnectionFactories() {
        if (!CollectionUtils.isEmpty(this.connections)) {
            this.connections.forEach(connectionFactoryProperties -> {
                CustomConnectionFactoryCreator connectionFactoryCreator = new CustomConnectionFactoryCreator((CustomConnectionFactoryProperties)connectionFactoryProperties);
                this.applicationContext.registerBean(connectionFactoryProperties.getBeanName(), ConnectionFactory.class, connectionFactoryCreator::createInstance, new BeanDefinitionCustomizer[]{beanDefinition -> beanDefinition.setScope("singleton")});
                log.info("ConnectionFactory build with bean-name '{}'", (Object)connectionFactoryProperties.getBeanName());
            });
        } else if (this.connectionFactory != null) {
            ConnectionFactory convertedConnectionFactory = ConnectionFactoryProvider.createConnectionFactory(this.connectionFactory, this.rabbitProperties, this.apiPort);
            this.applicationContext.registerBean(CONNECTION_FACTORY_BEAN_NAME, ConnectionFactory.class, () -> convertedConnectionFactory, new BeanDefinitionCustomizer[]{beanDefinition -> {
                beanDefinition.setScope("singleton");
                beanDefinition.setPrimary(true);
            }});
            log.info("ConnectionFactory converted to possible queueMasterLocatorConnectionFactory with bean name '{}'", (Object)CONNECTION_FACTORY_BEAN_NAME);
        } else {
            throw new IllegalArgumentException("No connection factory configured. Either configure the connection factory of Spring or declare some custom connection factories.");
        }
    }

    private void configureQueues() {
        this.queues.forEach(queueProperties -> {
            if (queueProperties.isCreationEnabled()) {
                String queueName = queueProperties.getName();
                RabbitAdminProperties rabbitAdminProperties = queueProperties.getRabbitAdmin();
                String rabbitAdminBeanName = rabbitAdminProperties.getBeanName();
                BeanReferenceConnectionFactoryProperties customConnectionFactoryProperties = rabbitAdminProperties.getConnectionFactory();
                ConnectionFactory resolvedConnectionFactory = DefaultValueResolver.resolveConnectionFactory(customConnectionFactoryProperties, CONNECTION_FACTORY_BEAN_NAME, this.applicationContext);
                RabbitAdmin rabbitAdmin = new RabbitAdminCreator(resolvedConnectionFactory).createInstance();
                if (!this.applicationContext.containsBean(rabbitAdminBeanName)) {
                    this.applicationContext.registerBean(rabbitAdminBeanName, RabbitAdmin.class, () -> rabbitAdmin, new BeanDefinitionCustomizer[]{beanDefinition -> beanDefinition.setScope("singleton")});
                    log.info("RabbitAdmin build with bean-name '{}'", (Object)rabbitAdminBeanName);
                }
                QueueCreator queueCreator = new QueueCreator((QueueProperties)queueProperties, rabbitAdmin, DefaultValueResolver.resolveExchange(queueProperties.getExchange(), this.exchange));
                this.addToContext(queueName, resolvedConnectionFactory, queueCreator.createInstance());
                DlxQueueCreator dlxQueueCreator = new DlxQueueCreator(rabbitAdmin, (QueueProperties)queueProperties);
                this.addToContext(queueName + ".dlx", resolvedConnectionFactory, dlxQueueCreator.createInstance());
                if (queueProperties.getListener() != null) {
                    ListenerProperties listenerProperties = queueProperties.getListener();
                    if (listenerProperties.isCreationEnabled()) {
                        String listenerBeanName = listenerProperties.getBeanName();
                        int resolvedPrefetchCount = DefaultValueResolver.resolveValue(listenerProperties.getPrefetchCount(), this.prefetchCount);
                        int resolvedMaxConcurrentConsumers = DefaultValueResolver.resolveValue(listenerProperties.getMaxConcurrentConsumers(), this.maxConcurrentConsumers);
                        MessageConverter resolvedMessageConverter = DefaultValueResolver.resolveMessageConverter(listenerProperties.getMessageConverter(), this.messageConverter, this.applicationContext, this.existingMessageConverterList);
                        Object listener = this.applicationContext.getBean(listenerBeanName);
                        ListenerCreator listenerCreator = new ListenerCreator(resolvedConnectionFactory, queueName, resolvedPrefetchCount, resolvedMaxConcurrentConsumers, resolvedMessageConverter, listener);
                        String beanName = SpringRabbitAutoConfiguration.createListenerContainerBeanName(listenerProperties, queueName, customConnectionFactoryProperties);
                        this.applicationContext.registerBean(beanName, DefaultMessageListenerContainer.class, listenerCreator::createInstance, new BeanDefinitionCustomizer[]{beanDefinition -> beanDefinition.setScope("singleton")});
                        log.info("MessageListenerContainer build with bean-name '{}'", (Object)beanName);
                    } else {
                        log.info("Listener creation disabled (name: {})", (Object)listenerProperties.getBeanName());
                    }
                }
            } else {
                log.info("Queue creation disabled (name: {})", (Object)queueProperties.getName());
            }
        });
    }

    private void addToContext(String name, ConnectionFactory resolvedConnectionFactory, Queue queue) {
        String beanName = name + "_" + resolvedConnectionFactory.getHost();
        this.applicationContext.registerBean(beanName, Queue.class, () -> queue, new BeanDefinitionCustomizer[]{beanDefinition -> beanDefinition.setScope("singleton")});
        log.info("Queue build with bean-name '{}'", (Object)beanName);
    }

    private void configureRabbitTemplates() {
        this.outbounds.forEach(rabbitTemplateProperties -> {
            String rabbitTemplateBeanName = rabbitTemplateProperties.getBeanName();
            Exchange resolvedExchange = DefaultValueResolver.resolveExchange(rabbitTemplateProperties.getExchange(), this.exchange);
            ConnectionFactory resolvedConnectionFactory = DefaultValueResolver.resolveConnectionFactory(rabbitTemplateProperties.getConnectionFactory(), CONNECTION_FACTORY_BEAN_NAME, this.applicationContext);
            MessageConverter resolvedMessageConverter = DefaultValueResolver.resolveMessageConverter(rabbitTemplateProperties.getMessageConverter(), this.messageConverter, this.applicationContext, this.existingMessageConverterList);
            List<MessagePostProcessor> totalMessagePostProcessors = this.resolveTotalMessagePostProcessors(rabbitTemplateBeanName);
            RabbitTemplateCreator rabbitTemplateCreator = new RabbitTemplateCreator(resolvedConnectionFactory, resolvedExchange, resolvedMessageConverter, (RabbitTemplateProperties)rabbitTemplateProperties, totalMessagePostProcessors);
            RabbitTemplate rabbitTemplate = (RabbitTemplate)rabbitTemplateCreator.createInstance();
            this.applicationContext.registerBean(rabbitTemplateBeanName, RabbitTemplate.class, () -> rabbitTemplate, new BeanDefinitionCustomizer[]{beanDefinition -> beanDefinition.setScope("singleton")});
            log.info("RabbitTemplate build with autowiredName " + rabbitTemplateBeanName);
        });
    }

    private List<MessagePostProcessor> resolveTotalMessagePostProcessors(String rabbitTemplateBeanName) {
        ArrayList<MessagePostProcessor> totalMessagePostProcessors = new ArrayList<MessagePostProcessor>(this.messagePostProcessors);
        totalMessagePostProcessors.addAll(MessagePostProcessorUtils.resolveAdditionalMessagePostProcessors(this.applicationContext.getEnvironment(), this.meterRegistry, rabbitTemplateBeanName));
        return totalMessagePostProcessors;
    }

    private static String createListenerContainerBeanName(ListenerProperties listenerProperties, String queueName, BeanReferenceConnectionFactoryProperties connectionFactoryProperties) {
        String connectionFactoryBeanName = DefaultValueResolver.resolveConnectionFactoryBeanName(connectionFactoryProperties, CONNECTION_FACTORY_BEAN_NAME);
        return listenerProperties.getBeanName() + "@" + queueName + "@" + connectionFactoryBeanName;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public RabbitProperties getRabbitProperties() {
        return this.rabbitProperties;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public GenericApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public List<MessageConverter> getExistingMessageConverterList() {
        return this.existingMessageConverterList;
    }

    public List<MessagePostProcessor> getMessagePostProcessors() {
        return this.messagePostProcessors;
    }

    public List<QueueProperties> getQueues() {
        return this.queues;
    }

    public List<RabbitTemplateProperties> getOutbounds() {
        return this.outbounds;
    }

    public List<CustomConnectionFactoryProperties> getConnections() {
        return this.connections;
    }

    public ExchangeProperties getExchange() {
        return this.exchange;
    }

    public MessageConverterProperties getMessageConverter() {
        return this.messageConverter;
    }

    public Integer getPrefetchCount() {
        return this.prefetchCount;
    }

    public Integer getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public int getApiPort() {
        return this.apiPort;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setRabbitProperties(RabbitProperties rabbitProperties) {
        this.rabbitProperties = rabbitProperties;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void setApplicationContext(GenericApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setExistingMessageConverterList(List<MessageConverter> existingMessageConverterList) {
        this.existingMessageConverterList = existingMessageConverterList;
    }

    public void setMessagePostProcessors(List<MessagePostProcessor> messagePostProcessors) {
        this.messagePostProcessors = messagePostProcessors;
    }

    public void setQueues(List<QueueProperties> queues) {
        this.queues = queues;
    }

    public void setOutbounds(List<RabbitTemplateProperties> outbounds) {
        this.outbounds = outbounds;
    }

    public void setConnections(List<CustomConnectionFactoryProperties> connections) {
        this.connections = connections;
    }

    public void setExchange(ExchangeProperties exchange) {
        this.exchange = exchange;
    }

    public void setMessageConverter(MessageConverterProperties messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setPrefetchCount(Integer prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public void setMaxConcurrentConsumers(Integer maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public void setApiPort(int apiPort) {
        this.apiPort = apiPort;
    }

    @Configuration
    protected static class BeforePublishMessagePostProcessorAutoConfiguration {
        protected BeforePublishMessagePostProcessorAutoConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"spring.rabbitmq.outbound.global.before-publish-post-processor.appid-enricher.enabled"}, havingValue="true", matchIfMissing=true)
        public MessagePostProcessor appIdEnricherMessagePostProcessor(Environment environment) {
            String appId = environment.getProperty("spring.rabbitmq.outbound.global.before-publish-post-processor.appid-enricher.app-id");
            if (StringUtils.isEmpty((Object)appId)) {
                appId = environment.getProperty("info.artifactId", "UNKNOWN");
            }
            String resolvedAppId = appId;
            return message -> {
                message.getMessageProperties().setAppId(resolvedAppId);
                return message;
            };
        }

        @Bean
        @ConditionalOnMissingBean
        public MessagePostProcessor dummyMessagePostProcessor() {
            return message -> message;
        }
    }
}

