/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.configuration;

import java.util.Collection;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ErrorHandler;

public class ValidationErrorHandler
implements ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(ValidationErrorHandler.class);

    public void handleError(Throwable throwable) {
        if (throwable instanceof ConstraintViolationException) {
            ValidationErrorHandler.handleConstraintViolationException((ConstraintViolationException)throwable);
            return;
        }
        if (throwable.getCause() instanceof ConstraintViolationException) {
            ValidationErrorHandler.handleConstraintViolationException((ConstraintViolationException)throwable.getCause());
            return;
        }
        log.error(throwable.getMessage(), throwable);
    }

    private static void handleConstraintViolationException(ConstraintViolationException e) {
        if (CollectionUtils.isEmpty((Collection)e.getConstraintViolations())) {
            log.error(e.getMessage(), (Throwable)e);
        } else {
            log.error(ValidationErrorHandler.format((ConstraintViolation)e.getConstraintViolations().iterator().next()), (Throwable)e);
        }
    }

    private static String format(ConstraintViolation<?> violation) {
        return "INVALID " + violation.getPropertyPath() + " " + violation.getMessage() + ": " + violation.getRootBean() + " -- " + violation.getLeafBean();
    }
}

