/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.configuration.creator;

import com.avides.spring.rabbit.configuration.creator.Creator;
import com.avides.spring.rabbit.configuration.domain.CustomConnectionFactoryProperties;
import com.avides.spring.rabbit.configuration.provider.ConnectionFactoryProvider;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;

public class CustomConnectionFactoryCreator
implements Creator<ConnectionFactory> {
    private final CustomConnectionFactoryProperties customConnectionFactoryProperties;

    @Override
    public ConnectionFactory createInstance() {
        RabbitProperties rabbitProperties = this.createRabbitProperties();
        CachingConnectionFactory factory = CustomConnectionFactoryCreator.createCachingConnectionFactory(rabbitProperties);
        return ConnectionFactoryProvider.createConnectionFactory((ConnectionFactory)factory, rabbitProperties, this.customConnectionFactoryProperties.getApiPort());
    }

    private RabbitProperties createRabbitProperties() {
        RabbitProperties rabbitProperties = new RabbitProperties();
        rabbitProperties.setAddresses(this.customConnectionFactoryProperties.getAddresses());
        rabbitProperties.setUsername(this.customConnectionFactoryProperties.getUsername());
        rabbitProperties.setPassword(this.customConnectionFactoryProperties.getPassword());
        rabbitProperties.setVirtualHost(this.customConnectionFactoryProperties.getVirtualHost());
        return rabbitProperties;
    }

    private static CachingConnectionFactory createCachingConnectionFactory(RabbitProperties rabbitProperties) {
        CachingConnectionFactory factory = new CachingConnectionFactory();
        factory.setHost(rabbitProperties.determineHost());
        factory.setAddresses(rabbitProperties.determineAddresses());
        factory.setPort(rabbitProperties.determinePort());
        factory.setUsername(rabbitProperties.determineUsername());
        factory.setPassword(rabbitProperties.determinePassword());
        factory.setVirtualHost(rabbitProperties.determineVirtualHost());
        return factory;
    }

    public CustomConnectionFactoryCreator(CustomConnectionFactoryProperties customConnectionFactoryProperties) {
        this.customConnectionFactoryProperties = customConnectionFactoryProperties;
    }
}

