/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.configuration.creator;

import com.avides.spring.rabbit.configuration.creator.Creator;
import com.avides.spring.rabbit.configuration.domain.QueueProperties;
import java.util.HashMap;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;

public class DlxQueueCreator
implements Creator<Queue> {
    private final RabbitAdmin rabbitAdmin;
    private final QueueProperties queueProperties;

    @Override
    public Queue createInstance() {
        HashMap<String, Object> dlxArguments = new HashMap<String, Object>();
        dlxArguments.put("x-max-length", Long.valueOf(this.queueProperties.getLimit()));
        dlxArguments.put("x-queue-mode", "lazy");
        Queue dlxQueue = new Queue(this.queueProperties.getName() + ".dlx", this.queueProperties.isDurable(), this.queueProperties.isExclusive(), false, dlxArguments);
        dlxQueue.setAdminsThatShouldDeclare(new Object[]{this.rabbitAdmin});
        this.rabbitAdmin.declareQueue(dlxQueue);
        return dlxQueue;
    }

    public DlxQueueCreator(RabbitAdmin rabbitAdmin, QueueProperties queueProperties) {
        this.rabbitAdmin = rabbitAdmin;
        this.queueProperties = queueProperties;
    }
}

