/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.configuration.creator;

import com.avides.spring.rabbit.configuration.creator.Creator;
import com.avides.spring.rabbit.configuration.domain.ExchangeProperties;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.TopicExchange;

public class ExchangeCreator
implements Creator<Exchange> {
    private final ExchangeProperties exchangeProperties;

    @Override
    public Exchange createInstance() {
        switch (this.exchangeProperties.getType()) {
            case DIRECT: {
                return new DirectExchange(this.exchangeProperties.getName());
            }
            case TOPIC: {
                return new TopicExchange(this.exchangeProperties.getName());
            }
        }
        throw new IllegalArgumentException("Unsupported ExchangeType " + this.exchangeProperties.getType());
    }

    public ExchangeCreator(ExchangeProperties exchangeProperties) {
        this.exchangeProperties = exchangeProperties;
    }
}

