/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.configuration.creator;

import com.avides.spring.rabbit.configuration.creator.Creator;
import com.avides.spring.rabbit.listener.RabbitListener;
import com.avides.spring.rabbit.listener.SpringRabbitListener;
import com.avides.spring.rabbit.listener.container.DefaultMessageListenerContainer;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.support.converter.MessageConverter;

public class ListenerCreator
implements Creator<DefaultMessageListenerContainer<Object>> {
    private final ConnectionFactory connectionFactory;
    private final String queueName;
    private final int prefetchCount;
    private final int maxConcurrentConsumers;
    private final MessageConverter messageConverter;
    private final Object listener;

    @Override
    public DefaultMessageListenerContainer<Object> createInstance() {
        DefaultMessageListenerContainer<Object> container = new DefaultMessageListenerContainer<Object>(this.connectionFactory);
        container.setQueueNames(new String[]{this.queueName});
        container.setPrefetchCount(this.prefetchCount);
        container.setMaxConcurrentConsumers(this.maxConcurrentConsumers);
        this.apppendListenerToContainer(container, this.messageConverter);
        return container;
    }

    private void apppendListenerToContainer(DefaultMessageListenerContainer<Object> container, MessageConverter converter) {
        if (this.listener instanceof SpringRabbitListener) {
            container.setSpringRabbitListener((SpringRabbitListener)this.listener, converter);
        } else if (this.listener instanceof RabbitListener) {
            container.setListener((RabbitListener)this.listener, converter);
        } else {
            throw new IllegalArgumentException("Listener configuration failed (found listener class:" + this.listener.getClass() + ")");
        }
    }

    public ListenerCreator(ConnectionFactory connectionFactory, String queueName, int prefetchCount, int maxConcurrentConsumers, MessageConverter messageConverter, Object listener) {
        this.connectionFactory = connectionFactory;
        this.queueName = queueName;
        this.prefetchCount = prefetchCount;
        this.maxConcurrentConsumers = maxConcurrentConsumers;
        this.messageConverter = messageConverter;
        this.listener = listener;
    }
}

