/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.configuration.creator;

import com.avides.spring.rabbit.configuration.creator.Creator;
import com.avides.spring.rabbit.configuration.domain.QueueProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class QueueCreator
implements Creator<Queue> {
    private final QueueProperties queueProperties;
    private final RabbitAdmin rabbitAdmin;
    private final Exchange exchange;

    @Override
    public Queue createInstance() {
        List<String> routingKeys = this.createRoutingKeys();
        Map<String, Object> arguments = this.createArguments();
        Queue queue = new Queue(this.queueProperties.getName(), this.queueProperties.isDurable(), this.queueProperties.isExclusive(), false, arguments);
        queue.setAdminsThatShouldDeclare(new Object[]{this.rabbitAdmin});
        this.rabbitAdmin.declareQueue(queue);
        this.rabbitAdmin.declareExchange(this.exchange);
        routingKeys.forEach(routingKey -> this.rabbitAdmin.declareBinding(BindingBuilder.bind((Queue)queue).to(this.exchange).with(routingKey).noargs()));
        return queue;
    }

    private Map<String, Object> createArguments() {
        Map<String, Object> arguments = this.queueProperties.getArguments();
        arguments.put("x-dead-letter-exchange", "");
        arguments.put("x-dead-letter-routing-key", this.queueProperties.getName() + ".dlx");
        arguments.put("x-max-length", this.queueProperties.getLimit());
        return arguments;
    }

    private List<String> createRoutingKeys() {
        ArrayList<String> routingKeys = new ArrayList<String>();
        if (StringUtils.hasText((String)this.queueProperties.getRoutingkey())) {
            QueueCreator.checkRoutingKey(this.queueProperties.getRoutingkey());
            routingKeys.add(this.queueProperties.getRoutingkey());
        } else if (!CollectionUtils.isEmpty(this.queueProperties.getRoutingkeys())) {
            this.queueProperties.getRoutingkeys().forEach(routingKey -> {
                QueueCreator.checkRoutingKey(routingKey);
                routingKeys.add((String)routingKey);
            });
        } else {
            throw new IllegalArgumentException("Either declare routing-keys or routing-key");
        }
        return routingKeys;
    }

    private static boolean checkRoutingKey(String routingkey) {
        if (!StringUtils.hasText((String)routingkey)) {
            throw new IllegalArgumentException("Invalid routing-key");
        }
        return true;
    }

    public QueueCreator(QueueProperties queueProperties, RabbitAdmin rabbitAdmin, Exchange exchange) {
        this.queueProperties = queueProperties;
        this.rabbitAdmin = rabbitAdmin;
        this.exchange = exchange;
    }
}

