/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.configuration.creator;

import com.avides.spring.rabbit.configuration.creator.Creator;
import com.avides.spring.rabbit.configuration.domain.RabbitTemplateProperties;
import java.util.List;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;

public class RabbitTemplateCreator
implements Creator<RabbitTemplate> {
    private final ConnectionFactory connectionFactory;
    private final Exchange exchange;
    private final MessageConverter messageConverter;
    private final RabbitTemplateProperties rabbitTemplateProperties;
    private final List<MessagePostProcessor> beforePublishPostProcessors;

    @Override
    public RabbitTemplate createInstance() {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(this.connectionFactory);
        new RabbitAdmin(this.connectionFactory).declareExchange(this.exchange);
        rabbitTemplate.setExchange(this.exchange.getName());
        rabbitTemplate.setMessageConverter(this.messageConverter);
        rabbitTemplate.setRoutingKey(this.rabbitTemplateProperties.getRoutingkey());
        rabbitTemplate.addBeforePublishPostProcessors(this.beforePublishPostProcessors.toArray(new MessagePostProcessor[this.beforePublishPostProcessors.size()]));
        return rabbitTemplate;
    }

    public RabbitTemplateCreator(ConnectionFactory connectionFactory, Exchange exchange, MessageConverter messageConverter, RabbitTemplateProperties rabbitTemplateProperties, List<MessagePostProcessor> beforePublishPostProcessors) {
        this.connectionFactory = connectionFactory;
        this.exchange = exchange;
        this.messageConverter = messageConverter;
        this.rabbitTemplateProperties = rabbitTemplateProperties;
        this.beforePublishPostProcessors = beforePublishPostProcessors;
    }
}

