/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.configuration.domain;

import com.rabbitmq.http.client.Client;
import com.rabbitmq.http.client.domain.QueueInfo;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.RoutingConnectionFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;

public class QueueMasterLocatorConnectionFactory
implements ConnectionFactory,
RoutingConnectionFactory,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(QueueMasterLocatorConnectionFactory.class);
    private ConnectionFactory defaultConnectionFactory;
    private RabbitProperties rabbitProperties;
    private Map<String, ConnectionFactory> nodeConnectionFactories = new HashMap<String, ConnectionFactory>();
    private int apiPort;

    public QueueMasterLocatorConnectionFactory(ConnectionFactory defaultConnectionFactory, RabbitProperties rabbitProperties, int apiPort) {
        this.defaultConnectionFactory = defaultConnectionFactory;
        this.rabbitProperties = rabbitProperties;
        this.apiPort = apiPort;
    }

    public ConnectionFactory getTargetConnectionFactory(Object key) {
        String queueName = (String)key;
        Assert.isTrue((!(queueName = queueName.substring(1, queueName.length() - 1)).contains(",") ? 1 : 0) != 0, (String)("Cannot use QueueMasterLocatorConnectionFactory with more than one queue: " + key));
        ConnectionFactory queueMasterConnectionFactory = this.getConnectionFactoryForQueue(queueName);
        return queueMasterConnectionFactory != null ? queueMasterConnectionFactory : this.defaultConnectionFactory;
    }

    private ConnectionFactory getConnectionFactoryForQueue(String queueName) {
        String queueMasterNode = this.resolveMasterNodeForQueue(this.getQueueInfo(queueName));
        if (queueMasterNode != null) {
            if (this.nodeConnectionFactories.get(queueMasterNode) == null) {
                CachingConnectionFactory nodeConnectionFactory = new CachingConnectionFactory();
                nodeConnectionFactory.setBeanName("rabbitNodeConnectionFactory:" + queueMasterNode);
                nodeConnectionFactory.setHost(queueMasterNode);
                nodeConnectionFactory.setPort(this.rabbitProperties.determinePort());
                nodeConnectionFactory.setVirtualHost(StringUtils.hasText((String)this.rabbitProperties.determineVirtualHost()) ? this.rabbitProperties.determineVirtualHost() : "/");
                nodeConnectionFactory.setUsername(this.rabbitProperties.determineUsername());
                nodeConnectionFactory.setPassword(this.rabbitProperties.determinePassword());
                this.nodeConnectionFactories.put(queueMasterNode, (ConnectionFactory)nodeConnectionFactory);
                log.debug("Created connectionFactory for node " + queueMasterNode);
            }
            return this.nodeConnectionFactories.get(queueMasterNode);
        }
        return null;
    }

    private QueueInfo getQueueInfo(String queueName) {
        try {
            Client client = new Client("http://" + this.getHost() + ":" + this.apiPort + "/api/", this.getUsername(), this.rabbitProperties.getPassword());
            return client.getQueue(this.getVirtualHost(), queueName);
        }
        catch (HttpClientErrorException e) {
            if (e.getRawStatusCode() == 401) {
                log.warn("Rabbit-user needs 'monitoring'-role to fetch information for " + queueName, (Throwable)e);
            } else {
                log.warn("Failed to fetch queue-master for " + queueName, (Throwable)e);
            }
        }
        catch (Exception e) {
            log.warn("Failed to fetch queue-master for " + queueName, (Throwable)e);
        }
        return null;
    }

    String resolveMasterNodeForQueue(QueueInfo queueInfo) {
        if (queueInfo == null) {
            return null;
        }
        if (queueInfo.isExclusive()) {
            return null;
        }
        return queueInfo.getNode().replaceAll("rabbit@", "");
    }

    public Connection createConnection() {
        return this.defaultConnectionFactory.createConnection();
    }

    public String getHost() {
        return this.defaultConnectionFactory.getHost();
    }

    public int getPort() {
        return this.defaultConnectionFactory.getPort();
    }

    public String getVirtualHost() {
        return this.defaultConnectionFactory.getVirtualHost();
    }

    public String getUsername() {
        return this.defaultConnectionFactory.getUsername();
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.defaultConnectionFactory.addConnectionListener(listener);
    }

    public boolean removeConnectionListener(ConnectionListener listener) {
        return this.defaultConnectionFactory.removeConnectionListener(listener);
    }

    public void clearConnectionListeners() {
        this.defaultConnectionFactory.clearConnectionListeners();
    }

    public void destroy() throws Exception {
        for (ConnectionFactory connectionFactory : this.nodeConnectionFactories.values()) {
            ((DisposableBean)connectionFactory).destroy();
        }
    }
}

