/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.configuration.provider;

import com.avides.spring.rabbit.configuration.domain.QueueMasterLocatorConnectionFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;

public final class ConnectionFactoryProvider {
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactoryProvider.class);

    public static ConnectionFactory createConnectionFactory(ConnectionFactory defaultConnectionFactory, RabbitProperties rabbitProperties, int apiPort) {
        String host = rabbitProperties.determineHost();
        if (!"localhost".equals(host) && !rabbitProperties.determineAddresses().contains(",")) {
            try {
                InetAddress[] inetAddresses = InetAddress.getAllByName(host);
                if (inetAddresses.length > 1) {
                    log.debug("Create new QueueMasterLocatorConnectionFactory for nodes: {}", (Object)inetAddresses);
                    return new QueueMasterLocatorConnectionFactory(defaultConnectionFactory, rabbitProperties, apiPort);
                }
            }
            catch (UnknownHostException e) {
                log.warn("Cannot rersolve domain: {}", (Object)host, (Object)e);
            }
        }
        log.debug("Use defaultConnectionFactory: {}", (Object)defaultConnectionFactory);
        return defaultConnectionFactory;
    }

    private ConnectionFactoryProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

