/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.configuration.util;

import com.avides.spring.rabbit.configuration.creator.ExchangeCreator;
import com.avides.spring.rabbit.configuration.domain.BeanReferenceConnectionFactoryProperties;
import com.avides.spring.rabbit.configuration.domain.ExchangeProperties;
import com.avides.spring.rabbit.configuration.domain.MessageConverterProperties;
import java.util.List;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class DefaultValueResolver {
    public static Exchange resolveExchange(ExchangeProperties customProperties, ExchangeProperties defaultProperties) {
        if (customProperties != null) {
            return new ExchangeCreator(customProperties).createInstance();
        }
        if (defaultProperties != null) {
            return new ExchangeCreator(defaultProperties).createInstance();
        }
        throw new IllegalArgumentException("Could not resolve exchange");
    }

    public static ConnectionFactory resolveConnectionFactory(BeanReferenceConnectionFactoryProperties customProperties, String defaultBeanName, GenericApplicationContext applicationContext) {
        if (customProperties != null) {
            ConnectionFactory customConnectionFactory = (ConnectionFactory)applicationContext.getBean(customProperties.getBeanName(), ConnectionFactory.class);
            Assert.notNull((Object)customConnectionFactory, (String)("QueueMasterLocatorConnectionFactory not found (" + customProperties + ")"));
            return customConnectionFactory;
        }
        if (StringUtils.hasText((String)defaultBeanName)) {
            ConnectionFactory defaultConnectionFactory = (ConnectionFactory)applicationContext.getBean(defaultBeanName, ConnectionFactory.class);
            Assert.notNull((Object)defaultConnectionFactory, (String)("DefaultConnectionFactory not found (beanName:" + defaultBeanName + ")"));
            return defaultConnectionFactory;
        }
        throw new IllegalArgumentException("Could not resolve the connectionFactory");
    }

    public static String resolveConnectionFactoryBeanName(BeanReferenceConnectionFactoryProperties customProperties, String defaultBeanName) {
        return customProperties != null ? customProperties.getBeanName() : defaultBeanName;
    }

    @Deprecated(forRemoval=true, since="2.6.0")
    public static int resolveMaxConcurrentConsumers(Integer customMax, Integer defaultMax) {
        return DefaultValueResolver.resolveValue(customMax, defaultMax);
    }

    public static int resolveValue(Integer customValue, Integer defaultValue) {
        return customValue != null ? customValue.intValue() : defaultValue.intValue();
    }

    public static MessageConverter resolveMessageConverter(MessageConverterProperties customProperties, MessageConverterProperties defaultProperties, GenericApplicationContext applicationContext, List<MessageConverter> existingMessageConverters) {
        if (customProperties != null) {
            MessageConverter customMessageConverter = (MessageConverter)applicationContext.getBean(customProperties.getBeanName(), MessageConverter.class);
            Assert.notNull((Object)customMessageConverter, (String)("CustomMessageConverter not found (" + customProperties + ")"));
            return customMessageConverter;
        }
        if (defaultProperties != null) {
            MessageConverter defaultMessageConverter = (MessageConverter)applicationContext.getBean(defaultProperties.getBeanName(), MessageConverter.class);
            Assert.notNull((Object)defaultMessageConverter, (String)("DefaultMessageConverter not found (" + defaultProperties + ")"));
            return defaultMessageConverter;
        }
        if (existingMessageConverters.size() == 1) {
            return existingMessageConverters.get(0);
        }
        throw new IllegalArgumentException("Could not resolve messageConverter (existingMessageConverter size " + existingMessageConverters.size() + "))");
    }

    private DefaultValueResolver() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

