/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.configuration.util;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.List;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;

public final class MessagePostProcessorUtils {
    public static List<MessagePostProcessor> resolveAdditionalMessagePostProcessors(ConfigurableEnvironment environment, MeterRegistry meterRegistry, String rabbitTemplateBeanName) {
        ArrayList<MessagePostProcessor> messagePostProcessors = new ArrayList<MessagePostProcessor>();
        if (((Boolean)environment.getProperty("spring.rabbitmq.outbound.global.before-publish-post-processor.counting-outbound.enabled", Boolean.class, (Object)Boolean.TRUE)).booleanValue()) {
            messagePostProcessors.add(message -> {
                meterRegistry.counter("rabbit.outbound.message", new String[]{"template", rabbitTemplateBeanName}).increment();
                return message;
            });
        }
        return messagePostProcessors;
    }

    private MessagePostProcessorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

