/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.converter;

import com.avides.spring.rabbit.converter.SpringRabbitMessageConverter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConversionException;

public class SpringRabbitJsonMessageConverter
extends Jackson2JsonMessageConverter
implements SpringRabbitMessageConverter {
    public SpringRabbitJsonMessageConverter() {
    }

    public SpringRabbitJsonMessageConverter(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public <T> T fromMessage(Message message, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(message.getBody(), clazz);
        }
        catch (IOException e) {
            throw new MessageConversionException("Could not convert incoming message with class [" + clazz + "] and body [" + new String(message.getBody()) + "]", (Throwable)e);
        }
    }
}

