/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.listener;

import com.avides.spring.rabbit.listener.SpringRabbitListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.StringUtils;

public abstract class AbstractSpringRabbitListener<T>
implements SpringRabbitListener<T> {
    @Lazy
    @Autowired
    protected MeterRegistry meterRegistry;

    protected void handleEvent(T object) {
        throw new UnsupportedOperationException("Implementation of AbstractSpringRabbitListener has to override one of the handleEvent methods");
    }

    protected void handleEvent(T object, MessageProperties messageProperties) {
        this.handleEvent(object);
    }

    @Override
    public void handle(T object, MessageProperties messageProperties) {
        long started = System.currentTimeMillis();
        this.handleEvent(object, messageProperties);
        this.count(started, messageProperties);
    }

    private void count(long started, MessageProperties messageProperties) {
        if (this.meterRegistry != null) {
            String appId = StringUtils.hasText((String)messageProperties.getAppId()) ? messageProperties.getAppId() : "UNKNOWN";
            Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"listener", (String)this.getClass().getSimpleName()), Tag.of((String)"from", (String)appId)});
            this.meterRegistry.counter("rabbit.listener.event", (Iterable)tags).increment();
            long duration = System.currentTimeMillis() - started;
            this.meterRegistry.counter("rabbit.listener.event.total.duration.milliseconds", (Iterable)tags).increment((double)duration);
        }
    }
}

