/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.listener;

import com.avides.spring.rabbit.listener.AbstractSpringRabbitListener;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public abstract class OptionalResponseSpringRabbitListener<T>
extends AbstractSpringRabbitListener<T> {
    private RabbitTemplate responseRabbitTemplate;

    public OptionalResponseSpringRabbitListener(RabbitTemplate responseRabbitTemplate) {
        this.responseRabbitTemplate = responseRabbitTemplate;
    }

    protected abstract Object processRequest(T var1);

    @Override
    protected void handleEvent(T requestObject, MessageProperties messageProperties) {
        String replyQueueName = messageProperties.getReplyTo();
        Object responseObject = this.processRequest(requestObject);
        if (responseObject != null && replyQueueName != null) {
            this.responseRabbitTemplate.convertAndSend("", replyQueueName, responseObject, message -> {
                message.getMessageProperties().setCorrelationId(messageProperties.getCorrelationId());
                return message;
            });
        }
    }
}

