/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.listener;

import com.avides.spring.rabbit.listener.AbstractSpringRabbitListener;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.util.Assert;

public abstract class RequestResponseSpringRabbitListener<T>
extends AbstractSpringRabbitListener<T> {
    private RabbitTemplate responseRabbitTemplate;

    public RequestResponseSpringRabbitListener(RabbitTemplate responseRabbitTemplate) {
        this.responseRabbitTemplate = responseRabbitTemplate;
    }

    protected abstract Object processRequest(T var1);

    @Override
    protected void handleEvent(T requestObject, MessageProperties messageProperties) {
        String correlationId = messageProperties.getCorrelationId();
        String replyQueueName = messageProperties.getReplyTo();
        Assert.notNull((Object)replyQueueName, (String)"reply_to must not be null");
        Object responseObject = this.processRequest(requestObject);
        if (responseObject != null) {
            this.responseRabbitTemplate.convertAndSend("", replyQueueName, responseObject, message -> {
                message.getMessageProperties().setCorrelationId(correlationId);
                return message;
            });
        }
    }
}

