/*
 * Decompiled with CFR 0.152.
 */
package com.avides.spring.rabbit.listener.container;

import com.avides.spring.rabbit.configuration.ValidationErrorHandler;
import com.avides.spring.rabbit.converter.SpringRabbitMessageConverter;
import com.avides.spring.rabbit.listener.ContextAwareRabbitListener;
import com.avides.spring.rabbit.listener.RabbitListener;
import com.avides.spring.rabbit.listener.SpringRabbitListener;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.BlockingQueueConsumer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.adapter.MessageListenerAdapter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.util.Assert;

public class DefaultMessageListenerContainer<T>
extends SimpleMessageListenerContainer {
    public DefaultMessageListenerContainer(ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"connectionFactory must not be null");
        this.setConnectionFactory(connectionFactory);
        this.setErrorHandler(new ValidationErrorHandler());
        this.setDefaultRequeueRejected(false);
        this.setPrefetchCount(500);
        this.setMissingQueuesFatal(false);
    }

    protected BlockingQueueConsumer createBlockingQueueConsumer() {
        BlockingQueueConsumer consumer = super.createBlockingQueueConsumer();
        consumer.setDeclarationRetries(1000000);
        return consumer;
    }

    public void setSpringRabbitListener(SpringRabbitListener<T> sprinRbbitListener, MessageConverter messageConverter) {
        this.setMessageListener((MessageListener)this.resolveMessageListenerAdapter(sprinRbbitListener, messageConverter));
    }

    @Deprecated(forRemoval=true)
    public void setListener(RabbitListener<T> rabbitListener, MessageConverter messageConverter) {
        this.setMessageListener((MessageListener)this.resolveMessageListenerAdapter(rabbitListener, messageConverter));
    }

    @Deprecated(forRemoval=true)
    public void setContextAwareListener(ContextAwareRabbitListener<T> rabbitListener, MessageConverter messageConverter) {
        this.setMessageListener((MessageListener)this.resolveMessageListenerAdapter(rabbitListener, messageConverter));
    }

    private MessageListenerAdapter resolveMessageListenerAdapter(RabbitListener<T> rabbitListener, MessageConverter messageConverter) {
        Assert.notNull(rabbitListener, (String)"rabbitListener must not be null");
        Assert.notNull((Object)messageConverter, (String)"messageConverter must not be null");
        if (messageConverter instanceof SpringRabbitMessageConverter) {
            Class listenerClassType = rabbitListener.getGenericTypeClass();
            return new MessageListenerAdapter(message -> {
                Object object = ((SpringRabbitMessageConverter)messageConverter).fromMessage(message, listenerClassType);
                rabbitListener.handle(object);
            });
        }
        return new MessageListenerAdapter(message -> {
            Object object = messageConverter.fromMessage(message);
            rabbitListener.handle(object);
        });
    }

    private MessageListenerAdapter resolveMessageListenerAdapter(SpringRabbitListener<T> springRabbitListener, MessageConverter messageConverter) {
        Assert.notNull(springRabbitListener, (String)"springRabbitListener must not be null");
        Assert.notNull((Object)messageConverter, (String)"messageConverter must not be null");
        if (messageConverter instanceof SpringRabbitMessageConverter) {
            Class listenerClassType = springRabbitListener.getGenericTypeClass();
            return new MessageListenerAdapter(message -> {
                Object object = ((SpringRabbitMessageConverter)messageConverter).fromMessage(message, listenerClassType);
                springRabbitListener.handle(object, message.getMessageProperties());
            });
        }
        return new MessageListenerAdapter(message -> {
            Object object = messageConverter.fromMessage(message);
            springRabbitListener.handle(object, message.getMessageProperties());
        });
    }
}

