/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.log4j.sqs;

import com.avioconsulting.log4j.sqs.SqsManager;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;

@Plugin(name="SQS", category="Core", elementType="appender", printObject=true)
class SqsAppender
extends AbstractAppender {
    private final SqsManager manager;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public SqsAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, SqsManager manager) {
        super(name, filter, layout, ignoreExceptions);
        this.manager = Objects.requireNonNull(manager, "manager");
    }

    public void start() {
        super.start();
        this.manager.startup();
    }

    public void append(LogEvent event) {
        try {
            this.manager.send(this.getLayout(), event);
        }
        catch (Exception e) {
            this.error("Unable to sent SQS message in appender [" + this.getName() + "]", event, e);
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        this.setStopped();
        return stopped &= this.manager.stop(timeout, timeUnit);
    }

    public String toString() {
        return "SqsAppender{name=" + this.getName() + ", state=" + this.getState() + '}';
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<SqsAppender> {
        @PluginBuilderAttribute
        @Required(message="No AWS Access Key provided for SQSAppender")
        private String awsAccessKey;
        @PluginBuilderAttribute
        @Required(message="No AWS Secret Key provided for SQSAppender")
        private String awsSecretKey;
        @PluginBuilderAttribute
        @Required(message="No AWS Region provided for SQSAppender")
        private String awsRegion;
        @PluginBuilderAttribute
        @Required(message="No SQS Queue provided for SQSAppender")
        private String queueName;
        @PluginBuilderAttribute
        private String largeMessageQueueName;
        @PluginBuilderAttribute
        private Integer maxBatchOpenMs;
        @PluginBuilderAttribute
        private Integer maxBatchSize;
        @PluginBuilderAttribute
        private Integer maxInflightOutboundBatches;
        @PluginBuilderAttribute
        private Integer maxMessageBytes;
        @PluginBuilderAttribute
        private Boolean largeMessagesEnabled;
        private static final Logger logger = LogManager.getLogger();

        public SqsAppender build() {
            logger.debug("Initializing SQS appender");
            SqsManager manager = new SqsManager(this.getConfiguration(), this.getConfiguration().getLoggerContext(), this.getName(), this.awsRegion, this.awsAccessKey, this.awsSecretKey, this.queueName, this.largeMessageQueueName, this.maxBatchOpenMs, this.maxBatchSize, this.maxInflightOutboundBatches, this.maxMessageBytes, this.largeMessagesEnabled);
            return new SqsAppender(this.getName(), (Layout<? extends Serializable>)this.getLayout(), this.getFilter(), this.isIgnoreExceptions(), manager);
        }

        public String getAwsAccessKey() {
            return this.awsAccessKey;
        }

        public String getAwsSecretKey() {
            return this.awsSecretKey;
        }

        public String getAwsRegion() {
            return this.awsRegion;
        }

        public String getQueueName() {
            return this.queueName;
        }

        public String getLargeMessageQueueName() {
            return this.largeMessageQueueName;
        }

        public Integer getMaxBatchOpenMs() {
            return this.maxBatchOpenMs;
        }

        public Integer getMaxBatchSize() {
            return this.maxBatchSize;
        }

        public Integer getMaxInflightOutboundBatches() {
            return this.maxInflightOutboundBatches;
        }

        public Integer getMaxMessageBytes() {
            return this.maxMessageBytes;
        }

        public Boolean getLargeMessagesEnabled() {
            return this.largeMessagesEnabled;
        }

        public B setAwsAccessKey(String awsAccessKey) {
            this.awsAccessKey = awsAccessKey;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setAwsSecretKey(String awsSecretKey) {
            this.awsSecretKey = awsSecretKey;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setQueueName(String queueName) {
            this.queueName = queueName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setLargeMessageQueueName(String largeMessageQueueName) {
            this.largeMessageQueueName = largeMessageQueueName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setMaxBatchOpenMs(Integer maxBatchOpenMs) {
            this.maxBatchOpenMs = maxBatchOpenMs;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setMaxInflightOutboundBatches(Integer maxInflightOutboundBatches) {
            this.maxInflightOutboundBatches = maxInflightOutboundBatches;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setMaxMessageBytes(Integer maxMessageBytes) {
            this.maxMessageBytes = maxMessageBytes;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setLargeMessagesEnabled(Boolean largeMessagesEnabled) {
            this.largeMessagesEnabled = largeMessagesEnabled;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

