/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.log4j.sqs;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClientBuilder;
import com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient;
import com.amazonaws.services.sqs.buffered.QueueBufferConfig;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.config.Configuration;

public class SqsManager
extends AbstractManager {
    private final Configuration configuration;
    private final String awsAccessKey;
    private final String awsSecretKey;
    private final String awsRegion;
    private final String queueName;
    private final String largeMessageQueueName;
    private final Integer maxBatchOpenMs;
    private final Integer maxBatchSize;
    private final Integer maxInflightOutboundBatches;
    private final Integer maxMessageBytes;
    private final Boolean largeMessagesEnabled;
    private String queueUrl;
    private String largeMessageQueueUrl;
    private AmazonSQSBufferedAsyncClient client;
    private static final Logger logger = LogManager.getLogger();

    protected SqsManager(Configuration configuration, LoggerContext loggerContext, String name, String awsRegion, String awsAccessKey, String awsSecretKey, String queueName, String largeMessageQueueName, Integer maxBatchOpenMs, Integer maxBatchSize, Integer maxInflightOutboundBatches, Integer maxMessageBytes, Boolean largeMessagesEnabled) {
        super(loggerContext, name);
        this.configuration = Objects.requireNonNull(configuration);
        this.awsAccessKey = awsAccessKey;
        this.awsSecretKey = awsSecretKey;
        this.awsRegion = awsRegion;
        this.queueName = queueName;
        this.largeMessageQueueName = largeMessageQueueName == null ? queueName.concat(".fifo") : largeMessageQueueName;
        this.maxBatchOpenMs = maxBatchOpenMs == null ? 200 : maxBatchOpenMs;
        this.maxBatchSize = maxBatchSize == null ? 10 : maxBatchSize;
        this.maxInflightOutboundBatches = maxInflightOutboundBatches == null ? 5 : maxInflightOutboundBatches;
        this.maxMessageBytes = maxMessageBytes == null ? 250000 : maxMessageBytes;
        this.largeMessagesEnabled = largeMessagesEnabled != null && largeMessagesEnabled != false;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void startup() {
    }

    public void send(Layout<?> layout, LogEvent event) {
        try {
            String message = new String(layout.toByteArray(event), StandardCharsets.UTF_8);
            int messageLength = message.getBytes().length;
            logger.debug("Message length: " + messageLength);
            if (messageLength > this.maxMessageBytes) {
                if (!this.largeMessagesEnabled.booleanValue()) {
                    logger.debug("Sending truncated message");
                    SendMessageRequest request = new SendMessageRequest(this.queueUrl, SqsManager.truncateStringByByteLength(message, "UTF-8", this.maxMessageBytes));
                    this.client.sendMessageAsync(request);
                } else {
                    logger.debug("Splitting large message");
                    UUID uuid = UUID.randomUUID();
                    logger.debug("Large Message UUID: " + uuid);
                    String[] splitMessage = SqsManager.splitStringByByteLength(message, "UTF-8", this.maxMessageBytes);
                    for (int i = 0; i < splitMessage.length; ++i) {
                        logger.debug(String.format("Sending message %d of %d", i + 1, splitMessage.length));
                        SendMessageRequest request = new SendMessageRequest(this.largeMessageQueueUrl, String.format("currentPart=%d|totalParts=%d|uuid=%s|message=%s", i + 1, splitMessage.length, uuid, splitMessage[i]));
                        request.setMessageGroupId(uuid.toString());
                        this.getClient().sendMessageAsync(request);
                    }
                }
            } else {
                SendMessageRequest request = new SendMessageRequest(this.queueUrl, message);
                this.getClient().sendMessageAsync(request);
            }
        }
        catch (Exception e) {
            logger.error("Failed to send message to SQS", (Throwable)e);
        }
    }

    private AmazonSQSBufferedAsyncClient getClient() {
        if (this.client == null) {
            try {
                logger.debug("Initializing SQS Client: " + (Object)((Object)this));
                AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.awsAccessKey, this.awsSecretKey));
                AmazonSQSAsyncClientBuilder clientBuilder = AmazonSQSAsyncClientBuilder.standard();
                AmazonSQSAsync asyncClient = (AmazonSQSAsync)((AmazonSQSAsyncClientBuilder)((AmazonSQSAsyncClientBuilder)clientBuilder.withRegion(this.awsRegion)).withCredentials((AWSCredentialsProvider)credentialsProvider)).build();
                QueueBufferConfig config = new QueueBufferConfig().withMaxBatchOpenMs((long)this.maxBatchOpenMs.intValue()).withMaxBatchSize(this.maxBatchSize.intValue()).withMaxInflightOutboundBatches(this.maxInflightOutboundBatches.intValue());
                this.client = new AmazonSQSBufferedAsyncClient(asyncClient, config);
                this.queueUrl = this.client.getQueueUrl(this.queueName).getQueueUrl();
                if (this.largeMessagesEnabled.booleanValue()) {
                    logger.debug("Large Messages Enabled. Large Message Queue: " + this.largeMessageQueueName);
                    this.largeMessageQueueUrl = this.client.getQueueUrl(this.largeMessageQueueName).getQueueUrl();
                }
            }
            catch (Exception e) {
                logger.error("Failed to initialize SQS Client", (Throwable)e);
                throw e;
            }
        }
        return this.client;
    }

    public String toString() {
        return "[ region=" + this.awsRegion + ", maxBatchOpenMs=" + this.maxBatchOpenMs + ", maxBatchSize=" + this.maxBatchSize + ", maxInflightOutboundBatches=" + this.maxInflightOutboundBatches + " ]";
    }

    protected static String[] splitStringByByteLength(String src, String encoding, int maxsize) {
        CoderResult result;
        Charset cs = Charset.forName(encoding);
        CharsetEncoder coder = cs.newEncoder();
        ByteBuffer out = ByteBuffer.allocate(maxsize);
        CharBuffer in = CharBuffer.wrap(src);
        ArrayList<String> ss = new ArrayList<String>();
        int pos = 0;
        do {
            result = coder.encode(in, out, true);
            int newpos = src.length() - in.length();
            String s = src.substring(pos, newpos);
            ss.add(s);
            pos = newpos;
            out.rewind();
        } while (result.isOverflow());
        return ss.toArray(new String[0]);
    }

    protected static String truncateStringByByteLength(String src, String encoding, int maxsize) {
        Charset cs = Charset.forName(encoding);
        CharsetEncoder coder = cs.newEncoder();
        ByteBuffer out = ByteBuffer.allocate(maxsize);
        CharBuffer in = CharBuffer.wrap(src);
        coder.encode(in, out, true);
        int pos = src.length() - in.length();
        return src.substring(0, pos);
    }
}

