/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.interceptor;

import com.avioconsulting.mule.opentelemetry.internal.interceptor.ProcessorTracingInterceptor;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FirstProcessorInterceptorFactory
implements ProcessorInterceptorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirstProcessorInterceptorFactory.class);
    public static final String MULE_OTEL_INTERCEPTOR_PROCESSOR_ENABLE_PROPERTY_NAME = "mule.otel.interceptor.processor.enable";
    private final boolean interceptorEnabled = Boolean.parseBoolean(System.getProperty("mule.otel.interceptor.processor.enable", "true"));
    private final MuleNotificationProcessor muleNotificationProcessor;

    @Inject
    public FirstProcessorInterceptorFactory(MuleNotificationProcessor muleNotificationProcessor) {
        this.muleNotificationProcessor = muleNotificationProcessor;
    }

    public ProcessorInterceptor get() {
        return new ProcessorTracingInterceptor(this.muleNotificationProcessor);
    }

    public boolean intercept(ComponentLocation location) {
        boolean intercept = false;
        if (this.interceptorEnabled && this.muleNotificationProcessor.hasConnection()) {
            String interceptPath = String.format("%s/processors/0", location.getRootContainerName());
            Optional<TypedComponentIdentifier> componentType = ((LocationPart)location.getParts().get(0)).getPartIdentifier().filter(c -> TypedComponentIdentifier.ComponentType.FLOW.equals((Object)c.getType()));
            boolean bl = intercept = componentType.isPresent() && interceptPath.equalsIgnoreCase(location.getLocation());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Will Intercept '{}'?: {}", (Object)location, (Object)intercept);
        }
        return intercept;
    }
}

