/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.interceptor;

import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import java.util.Map;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorTracingInterceptor
implements ProcessorInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorTracingInterceptor.class);
    private MuleNotificationProcessor muleNotificationProcessor;

    public ProcessorTracingInterceptor(MuleNotificationProcessor muleNotificationProcessor) {
        this.muleNotificationProcessor = muleNotificationProcessor;
    }

    public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("May Intercept with logic '{}'", (Object)location);
        }
        if (this.muleNotificationProcessor.getConnectionSupplier() != null && !event.getVariables().containsKey("OTEL_TRACE_CONTEXT")) {
            OpenTelemetryConnection openTelemetryConnection = this.muleNotificationProcessor.getConnectionSupplier().get();
            String transactionId = openTelemetryConnection.getTransactionStore().transactionIdFor((Event)event);
            event.addVariable("OTEL_TRACE_CONTEXT", openTelemetryConnection.getTraceContext(transactionId));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Intercepted with logic '{}'", (Object)location);
            }
        }
    }
}

