/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.config.TraceLevelConfiguration;
import com.avioconsulting.mule.opentelemetry.api.processor.ProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.internal.processor.FlowProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.GenericProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ProcessorComponentService;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleNotificationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MuleNotificationProcessor.class);
    public static final String MULE_OTEL_SPAN_PROCESSORS_ENABLE_PROPERTY_NAME = "mule.otel.span.processors.enable";
    private Supplier<OpenTelemetryConnection> connectionSupplier;
    private boolean spanAllProcessors;
    private TraceLevelConfiguration traceLevelConfiguration;
    private OpenTelemetryConnection openTelemetryConnection;
    ConfigurationComponentLocator configurationComponentLocator;
    private ProcessorComponentService processorComponentService;
    private final ProcessorComponent flowProcessorComponent;
    private final Map<String, String> systemPropMap = System.getProperties().stringPropertyNames().stream().filter(p -> p.contains(".otel.")).collect(Collectors.toMap(String::toLowerCase, System::getProperty));
    private final Optional<ProcessorComponent> genericProcessorComponent;

    @Inject
    public MuleNotificationProcessor(ConfigurationComponentLocator configurationComponentLocator) {
        this.configurationComponentLocator = configurationComponentLocator;
        this.flowProcessorComponent = new FlowProcessorComponent().withConfigurationComponentLocator(configurationComponentLocator);
        this.genericProcessorComponent = Optional.of(new GenericProcessorComponent().withConfigurationComponentLocator(configurationComponentLocator));
    }

    public boolean hasConnection() {
        return this.connectionSupplier != null;
    }

    public Supplier<OpenTelemetryConnection> getConnectionSupplier() {
        return this.connectionSupplier;
    }

    public void init(Supplier<OpenTelemetryConnection> connectionSupplier, boolean spanAllProcessors) {
        this.init(connectionSupplier, new TraceLevelConfiguration(spanAllProcessors, Collections.emptyList()));
    }

    public void init(Supplier<OpenTelemetryConnection> connectionSupplier, TraceLevelConfiguration traceLevelConfiguration) {
        this.connectionSupplier = connectionSupplier;
        this.spanAllProcessors = Boolean.parseBoolean(System.getProperty(MULE_OTEL_SPAN_PROCESSORS_ENABLE_PROPERTY_NAME, Boolean.toString(traceLevelConfiguration.isSpanAllProcessors())));
        this.traceLevelConfiguration = traceLevelConfiguration;
        this.processorComponentService = ProcessorComponentService.getInstance();
    }

    private void init() {
        if (this.openTelemetryConnection == null) {
            this.openTelemetryConnection = this.connectionSupplier.get();
        }
    }

    protected final void globalConfigSystemAttributes(String configName, Map<String, String> tags) {
        if (configName == null || configName.trim().isEmpty()) {
            return;
        }
        Objects.requireNonNull(tags, "Tags map cannot be null");
        String configRef = configName.toLowerCase();
        String replaceVal = configRef + ".otel.";
        this.systemPropMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(configRef)).forEach(entry -> {
            String propKey = ((String)entry.getKey()).substring(replaceVal.length());
            tags.put(propKey, (String)entry.getValue());
        });
    }

    public void handleProcessorStartEvent(MessageProcessorNotification notification) {
        try {
            this.getProcessorComponent(notification).ifPresent(processor -> {
                logger.trace("Handling '{}:{}' processor start event", (Object)notification.getResourceIdentifier(), (Object)notification.getComponent().getIdentifier());
                this.init();
                TraceComponent traceComponent = processor.getStartTraceComponent((EnrichedServerNotification)notification);
                SpanBuilder spanBuilder = this.openTelemetryConnection.spanBuilder(traceComponent.getSpanName()).setSpanKind(traceComponent.getSpanKind()).setStartTimestamp(Instant.ofEpochMilli(notification.getTimestamp()));
                this.globalConfigSystemAttributes(traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_CONFIG_REF.getKey()), traceComponent.getTags());
                traceComponent.getTags().forEach((arg_0, arg_1) -> ((SpanBuilder)spanBuilder).setAttribute(arg_0, arg_1));
                this.openTelemetryConnection.getTransactionStore().addProcessorSpan(traceComponent.getTransactionId(), traceComponent.getLocation(), spanBuilder);
            });
        }
        catch (Exception ex) {
            logger.error("Error in handling processor start event", (Throwable)ex);
            throw ex;
        }
    }

    Optional<ProcessorComponent> getProcessorComponent(MessageProcessorNotification notification) {
        ComponentIdentifier identifier = notification.getComponent().getIdentifier();
        boolean ignored = this.traceLevelConfiguration.getIgnoreMuleComponents().stream().anyMatch(mc -> mc.getNamespace().equalsIgnoreCase(identifier.getNamespace()) & (mc.getName().equalsIgnoreCase(identifier.getName()) || "*".equalsIgnoreCase(mc.getName())));
        if (this.spanAllProcessors && ignored) {
            return Optional.empty();
        }
        Optional<ProcessorComponent> processorComponent = this.processorComponentService.getProcessorComponentFor(identifier, this.configurationComponentLocator);
        if (!processorComponent.isPresent() && this.spanAllProcessors) {
            processorComponent = this.genericProcessorComponent;
        }
        return processorComponent;
    }

    public void handleProcessorEndEvent(MessageProcessorNotification notification) {
        try {
            this.getProcessorComponent(notification).ifPresent(processorComponent -> {
                logger.trace("Handling '{}:{}' processor end event ", (Object)notification.getResourceIdentifier(), (Object)notification.getComponent().getIdentifier());
                this.init();
                TraceComponent traceComponent = processorComponent.getEndTraceComponent((EnrichedServerNotification)notification);
                this.openTelemetryConnection.getTransactionStore().endProcessorSpan(traceComponent.getTransactionId(), traceComponent.getLocation(), span -> {
                    if (notification.getEvent().getError().isPresent()) {
                        Error error = (Error)notification.getEvent().getError().get();
                        span.recordException(error.getCause());
                    }
                    this.setSpanStatus(traceComponent, (Span)span);
                    if (traceComponent.getTags() != null) {
                        traceComponent.getTags().forEach((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1));
                    }
                }, Instant.ofEpochMilli(notification.getTimestamp()));
            });
        }
        catch (Exception ex) {
            logger.error("Error in handling processor end event", (Throwable)ex);
            throw ex;
        }
    }

    public void handleFlowStartEvent(PipelineMessageNotification notification) {
        try {
            logger.trace("Handling '{}' flow start event", (Object)notification.getResourceIdentifier());
            this.init();
            TraceComponent traceComponent = this.flowProcessorComponent.getSourceStartTraceComponent((EnrichedServerNotification)notification, this.openTelemetryConnection).get();
            SpanBuilder spanBuilder = this.openTelemetryConnection.spanBuilder(traceComponent.getSpanName()).setSpanKind(traceComponent.getSpanKind()).setParent(traceComponent.getContext()).setStartTimestamp(Instant.ofEpochMilli(notification.getTimestamp()));
            this.globalConfigSystemAttributes(traceComponent.getTags().get(SemanticAttributes.MULE_APP_FLOW_SOURCE_CONFIG_REF.getKey()), traceComponent.getTags());
            traceComponent.getTags().forEach((arg_0, arg_1) -> ((SpanBuilder)spanBuilder).setAttribute(arg_0, arg_1));
            this.openTelemetryConnection.getTransactionStore().startTransaction(traceComponent.getTransactionId(), traceComponent.getName(), spanBuilder);
        }
        catch (Exception ex) {
            logger.error("Error in handling " + notification.getResourceIdentifier() + " flow start event", (Throwable)ex);
            throw ex;
        }
    }

    public void handleFlowEndEvent(PipelineMessageNotification notification) {
        try {
            logger.trace("Handling '{}' flow end event", (Object)notification.getResourceIdentifier());
            this.init();
            TraceComponent traceComponent = this.flowProcessorComponent.getSourceEndTraceComponent((EnrichedServerNotification)notification, this.openTelemetryConnection).get();
            this.openTelemetryConnection.getTransactionStore().endTransaction(traceComponent.getTransactionId(), traceComponent.getName(), rootSpan -> {
                traceComponent.getTags().forEach((arg_0, arg_1) -> ((Span)rootSpan).setAttribute(arg_0, arg_1));
                this.setSpanStatus(traceComponent, (Span)rootSpan);
                if (notification.getException() != null) {
                    rootSpan.recordException((Throwable)notification.getException());
                }
            }, Instant.ofEpochMilli(notification.getTimestamp()));
        }
        catch (Exception ex) {
            logger.error("Error in handling " + notification.getResourceIdentifier() + " flow end event", (Throwable)ex);
            throw ex;
        }
    }

    private void setSpanStatus(TraceComponent traceComponent, Span span) {
        if (traceComponent.getStatusCode() != null && !StatusCode.UNSET.equals((Object)traceComponent.getStatusCode())) {
            span.setStatus(traceComponent.getStatusCode());
        }
    }
}

