/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class FlowSpan
implements Serializable {
    private final String flowName;
    private final Span span;
    private boolean ending = false;
    private final Map<String, Span> childSpans = new ConcurrentHashMap<String, Span>();
    private boolean ended = false;

    public FlowSpan(String flowName, Span span) {
        this.flowName = flowName;
        this.span = span;
    }

    public Span getSpan() {
        return this.span;
    }

    public Span addProcessorSpan(String location, SpanBuilder spanBuilder) {
        if (this.ending || this.ended) {
            throw new UnsupportedOperationException("Flow " + this.flowName + " span " + (this.ended ? "has ended." : "is ending."));
        }
        Span span = spanBuilder.setParent(Context.current().with((ImplicitContextKeyed)this.getSpan())).startSpan();
        this.childSpans.put(location, span);
        return span;
    }

    public void endProcessorSpan(String location, Consumer<Span> spanUpdater, Instant endTime) {
        if ((!this.ending || this.ended) && this.childSpans.containsKey(location)) {
            Span removed = this.childSpans.remove(location);
            if (spanUpdater != null) {
                spanUpdater.accept(removed);
            }
            removed.end(endTime);
        }
    }

    public void end(Instant endTime) {
        this.ending = true;
        this.childSpans.forEach((location, span) -> span.end(endTime));
        this.span.end(endTime);
        this.ended = true;
    }

    public Optional<Span> findSpan(String location) {
        return Optional.ofNullable(this.childSpans.get(location));
    }
}

