/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.connection;

import com.avioconsulting.mule.opentelemetry.internal.config.OpenTelemetryConfigWrapper;
import com.avioconsulting.mule.opentelemetry.internal.connection.TraceContextHandler;
import com.avioconsulting.mule.opentelemetry.internal.store.InMemoryTransactionStore;
import com.avioconsulting.mule.opentelemetry.internal.store.TransactionStore;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryConnection
implements TraceContextHandler {
    private final Logger logger = LoggerFactory.getLogger(OpenTelemetryConnection.class);
    private static final String INSTRUMENTATION_VERSION = "0.0.1-DEV";
    private static final String INSTRUMENTATION_NAME = "mule-opentelemetry-module-DEV";
    private final TransactionStore transactionStore;
    private static OpenTelemetryConnection openTelemetryConnection;
    private final OpenTelemetry openTelemetry;
    private final Tracer tracer;

    private OpenTelemetryConnection(OpenTelemetryConfigWrapper openTelemetryConfigWrapper) {
        Properties properties = OpenTelemetryConnection.getModuleProperties();
        String instrumentationVersion = properties.getProperty("module.version", INSTRUMENTATION_VERSION);
        String instrumentationName = properties.getProperty("module.artifactId", INSTRUMENTATION_NAME);
        this.logger.info("Initialising OpenTelemetry Mule 4 Agent for instrumentation {}:{}", (Object)instrumentationName, (Object)instrumentationVersion);
        AutoConfiguredOpenTelemetrySdkBuilder builder = AutoConfiguredOpenTelemetrySdk.builder();
        if (openTelemetryConfigWrapper != null) {
            HashMap<String, String> configMap = new HashMap<String, String>();
            if (openTelemetryConfigWrapper.getResource() != null) {
                configMap.putAll(openTelemetryConfigWrapper.getResource().getConfigMap());
            }
            if (openTelemetryConfigWrapper.getExporter() != null) {
                configMap.putAll(openTelemetryConfigWrapper.getExporter().getExporterProperties());
            }
            if (openTelemetryConfigWrapper.getSpanProcessorConfiguration() != null) {
                configMap.putAll(openTelemetryConfigWrapper.getSpanProcessorConfiguration().getConfigMap());
            }
            builder.addPropertiesSupplier(() -> Collections.unmodifiableMap(configMap));
            this.logger.debug("Creating OpenTelemetryConnection with properties: [" + configMap + "]");
        }
        builder.setServiceClassLoader(AutoConfiguredOpenTelemetrySdkBuilder.class.getClassLoader());
        this.openTelemetry = builder.build().getOpenTelemetrySdk();
        this.tracer = this.openTelemetry.getTracer(instrumentationName, instrumentationVersion);
        this.transactionStore = InMemoryTransactionStore.getInstance();
    }

    public static Optional<OpenTelemetryConnection> get() {
        return Optional.ofNullable(openTelemetryConnection);
    }

    public static synchronized OpenTelemetryConnection getInstance(OpenTelemetryConfigWrapper openTelemetryConfigWrapper) {
        if (openTelemetryConnection == null) {
            openTelemetryConnection = new OpenTelemetryConnection(openTelemetryConfigWrapper);
        }
        return openTelemetryConnection;
    }

    private static Properties getModuleProperties() {
        Properties moduleProperties = new Properties();
        try {
            InputStream resourceAsStream = OpenTelemetryConnection.class.getClassLoader().getResourceAsStream("mule-opentelemetry-module.properties");
            if (resourceAsStream != null) {
                moduleProperties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return moduleProperties;
    }

    public SpanBuilder spanBuilder(String spanName) {
        return this.tracer.spanBuilder(spanName);
    }

    @Override
    public <T> Context getTraceContext(T carrier, TextMapGetter<T> textMapGetter) {
        return this.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), carrier, textMapGetter);
    }

    public Map<String, String> getTraceContext(String transactionId) {
        Context transactionContext = this.getTransactionStore().getTransactionContext(transactionId);
        HashMap<String, String> traceContext = new HashMap<String, String>();
        traceContext.put("TRACE_TRANSACTION_ID", transactionId);
        traceContext.put("traceId", this.getTransactionStore().getTraceIdForTransaction(transactionId));
        this.logger.debug("Creating trace context for TRACE_TRANSACTION_ID=" + transactionId);
        try (Scope scope = transactionContext.makeCurrent();){
            this.injectTraceContext(traceContext, HashMapTextMapSetter.INSTANCE);
        }
        this.logger.debug("traceContext: [" + traceContext + "]");
        return Collections.unmodifiableMap(traceContext);
    }

    @Override
    public <T> void injectTraceContext(T carrier, TextMapSetter<T> textMapSetter) {
        this.openTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), carrier, textMapSetter);
    }

    public TransactionStore getTransactionStore() {
        return this.transactionStore;
    }

    public void invalidate() {
    }

    public static enum HashMapTextMapSetter implements TextMapSetter<Map<String, String>>
    {
        INSTANCE;


        public void set(@Nullable Map<String, String> carrier, String key, String value) {
            if (carrier != null) {
                carrier.put(key, value);
            }
        }
    }
}

