/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.internal.connection.TraceContextHandler;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.avioconsulting.mule.opentelemetry.internal.processor.TraceComponent;
import com.mulesoft.extension.mq.api.attributes.AnypointMQMessageAttributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;

public class AnypointMQProcessorComponent
extends AbstractProcessorComponent {
    @Override
    protected String getNamespace() {
        return "anypoint-mq";
    }

    @Override
    protected List<String> getOperations() {
        return Arrays.asList("publish", "consume", "ack", "nack");
    }

    @Override
    protected List<String> getSources() {
        return Collections.singletonList("subscriber");
    }

    @Override
    protected SpanKind getSpanKind() {
        return SpanKind.PRODUCER;
    }

    @Override
    protected String getDefaultSpanName(Map<String, String> tags) {
        if (tags.containsKey(SemanticAttributes.MESSAGING_DESTINATION_NAME.getKey())) {
            return this.formattedSpanName(tags.get(SemanticAttributes.MESSAGING_DESTINATION_NAME.getKey()), "publish");
        }
        if (tags.containsKey(SemanticAttributes.MESSAGING_DESTINATION.getKey())) {
            return this.formattedSpanName(tags.get(SemanticAttributes.MESSAGING_DESTINATION.getKey()), "send");
        }
        return super.getDefaultSpanName(tags);
    }

    private String formattedSpanName(String queueName, String operation) {
        return String.format("%s %s", queueName, operation);
    }

    @Override
    public TraceComponent getStartTraceComponent(EnrichedServerNotification notification) {
        TraceComponent startTraceComponent = super.getStartTraceComponent(notification);
        if ("consume".equalsIgnoreCase(startTraceComponent.getTags().get(com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk.SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey()))) {
            startTraceComponent = startTraceComponent.toBuilder().withSpanKind(SpanKind.CONSUMER).withSpanName(this.formattedSpanName(startTraceComponent.getTags().get(SemanticAttributes.MESSAGING_DESTINATION_NAME.getKey()), "receive")).build();
        }
        return startTraceComponent;
    }

    @Override
    protected <A> Map<String, String> getAttributes(Component component, TypedValue<A> attributes) {
        ComponentWrapper componentWrapper = new ComponentWrapper(component, this.configurationComponentLocator);
        Map<String, String> connectionParams = componentWrapper.getConfigConnectionParameters();
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(SemanticAttributes.MESSAGING_CONSUMER_ID.getKey(), connectionParams.get("clientId"));
        tags.put("messaging.consumer_id", connectionParams.get("clientId"));
        if (attributes != null && attributes.getValue() instanceof AnypointMQMessageAttributes) {
            AnypointMQMessageAttributes attrs = (AnypointMQMessageAttributes)attributes.getValue();
            tags.put(SemanticAttributes.MESSAGING_MESSAGE_ID.getKey(), attrs.getMessageId());
        }
        tags.put(SemanticAttributes.MESSAGING_DESTINATION_KIND.getKey(), "queue");
        tags.put("messaging.destination_kind", "queue");
        tags.put(SemanticAttributes.MESSAGING_SYSTEM.getKey(), "anypointmq");
        this.addTagIfPresent(componentWrapper.getParameters(), "destination", tags, SemanticAttributes.MESSAGING_DESTINATION.getKey());
        tags.put(SemanticAttributes.MESSAGING_PROTOCOL.getKey(), "http");
        this.addTagIfPresent(componentWrapper.getParameters(), "destination", tags, SemanticAttributes.MESSAGING_DESTINATION_NAME.getKey());
        this.addTagIfPresent(connectionParams, "url", tags, SemanticAttributes.MESSAGING_URL.getKey());
        return tags;
    }

    @Override
    public Optional<TraceComponent> getSourceStartTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        TypedValue attributesTypedValue = notification.getEvent().getMessage().getAttributes();
        AnypointMQMessageAttributes attributes = (AnypointMQMessageAttributes)attributesTypedValue.getValue();
        Map<String, String> tags = this.getAttributes(this.getSourceComponent(notification).orElse(notification.getComponent()), attributesTypedValue);
        tags.put(SemanticAttributes.MESSAGING_OPERATION.getKey(), "process");
        TraceComponent traceComponent = TraceComponent.newBuilder(notification.getResourceIdentifier()).withTags(tags).withTransactionId(this.getTransactionId(notification)).withSpanName(this.formattedSpanName(attributes.getDestination(), "process")).withStatsCode(StatusCode.OK).withSpanKind(SpanKind.CONSUMER).withContext(traceContextHandler.getTraceContext(attributes.getProperties(), AbstractProcessorComponent.ContextMapGetter.INSTANCE)).build();
        return Optional.of(traceComponent);
    }

    @Override
    public TraceComponent getEndTraceComponent(EnrichedServerNotification notification) {
        return this.getTraceComponentBuilderFor(notification).withStatsCode(StatusCode.OK).build();
    }

    @Override
    public Optional<TraceComponent> getSourceEndTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        return Optional.of(this.getTraceComponentBuilderFor(notification).withStatsCode(StatusCode.OK).build());
    }
}

