/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.internal.connection.TraceContextHandler;
import com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.avioconsulting.mule.opentelemetry.internal.processor.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ProcessorComponentService;
import io.opentelemetry.api.trace.SpanKind;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.notification.EnrichedServerNotification;

public class FlowProcessorComponent
extends AbstractProcessorComponent {
    @Override
    public boolean canHandle(ComponentIdentifier componentIdentifier) {
        return this.namespaceSupported(componentIdentifier) && this.operationSupported(componentIdentifier);
    }

    @Override
    protected String getNamespace() {
        return "mule";
    }

    @Override
    protected List<String> getSources() {
        return Collections.emptyList();
    }

    @Override
    protected List<String> getOperations() {
        return Collections.singletonList("flow");
    }

    @Override
    public TraceComponent getStartTraceComponent(EnrichedServerNotification notification) {
        if (!this.canHandle(notification.getComponent().getIdentifier())) {
            throw new RuntimeException("Unsupported component " + notification.getComponent().getIdentifier().toString() + " for flow processor.");
        }
        TraceComponent.Builder builder = TraceComponent.newBuilder(notification.getResourceIdentifier());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(SemanticAttributes.MULE_APP_FLOW_NAME.getKey(), notification.getResourceIdentifier());
        tags.put(SemanticAttributes.MULE_SERVER_ID.getKey(), notification.getServerId());
        tags.put(SemanticAttributes.MULE_CORRELATION_ID.getKey(), notification.getEvent().getCorrelationId());
        builder.withTags(tags).withTransactionId(this.getTransactionId(notification)).withSpanName(notification.getResourceIdentifier());
        return builder.build();
    }

    @Override
    public Optional<TraceComponent> getSourceStartTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        TraceComponent startTraceComponent = this.getStartTraceComponent(notification);
        TraceComponent.Builder builder = startTraceComponent.toBuilder().withSpanKind(SpanKind.SERVER);
        ComponentIdentifier sourceIdentifier = this.getSourceIdentifier(notification);
        if (sourceIdentifier == null) {
            return Optional.of(builder.build());
        }
        startTraceComponent.getTags().put(SemanticAttributes.MULE_APP_FLOW_SOURCE_NAME.getKey(), sourceIdentifier.getName());
        startTraceComponent.getTags().put(SemanticAttributes.MULE_APP_FLOW_SOURCE_NAMESPACE.getKey(), sourceIdentifier.getNamespace());
        Component sourceComponent = (Component)this.configurationComponentLocator.find(Location.builderFromStringRepresentation((String)notification.getEvent().getContext().getOriginatingLocation().getLocation()).build()).get();
        ComponentWrapper sourceWrapper = new ComponentWrapper(sourceComponent, this.configurationComponentLocator);
        startTraceComponent.getTags().put(SemanticAttributes.MULE_APP_FLOW_SOURCE_CONFIG_REF.getKey(), sourceWrapper.getConfigRef());
        ProcessorComponentService.getInstance().getProcessorComponentFor(sourceIdentifier, this.configurationComponentLocator).flatMap(processorComponent -> processorComponent.getSourceStartTraceComponent(notification, traceContextHandler)).ifPresent(sourceTrace -> {
            SpanKind sourceKind = sourceTrace.getSpanKind() != null ? sourceTrace.getSpanKind() : SpanKind.SERVER;
            startTraceComponent.getTags().putAll(sourceTrace.getTags());
            builder.withSpanKind(sourceKind).withSpanName(sourceTrace.getSpanName()).withTransactionId(sourceTrace.getTransactionId()).withContext(sourceTrace.getContext());
        });
        return Optional.of(builder.build());
    }

    @Override
    public Optional<TraceComponent> getSourceEndTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        TraceComponent traceComponent = this.getEndTraceComponent(notification);
        TraceComponent.Builder builder = traceComponent.toBuilder().withSpanKind(SpanKind.SERVER);
        ComponentIdentifier sourceIdentifier = this.getSourceIdentifier(notification);
        if (sourceIdentifier == null) {
            return Optional.of(builder.build());
        }
        ProcessorComponentService.getInstance().getProcessorComponentFor(sourceIdentifier, this.configurationComponentLocator).flatMap(processorComponent -> processorComponent.getSourceEndTraceComponent(notification, traceContextHandler)).ifPresent(sourceTrace -> {
            traceComponent.getTags().putAll(sourceTrace.getTags());
            builder.withStatsCode(sourceTrace.getStatusCode());
            builder.withTags(traceComponent.getTags());
        });
        return Optional.of(builder.build());
    }
}

