/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import java.util.Map;

public class TraceComponent {
    private Map<String, String> tags;
    private final String name;
    private String transactionId;
    private String spanName;
    private String location;
    private Context context;
    private SpanKind spanKind = SpanKind.INTERNAL;
    private String errorMessage;
    private StatusCode statusCode = StatusCode.UNSET;

    private TraceComponent(Builder builder) {
        this.tags = builder.tags;
        this.name = builder.name;
        this.transactionId = builder.transactionId;
        this.spanName = builder.spanName;
        this.location = builder.location;
        this.context = builder.context;
        this.spanKind = builder.spanKind;
        this.errorMessage = builder.errorMessage;
        this.statusCode = builder.statusCode;
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    public SpanKind getSpanKind() {
        return this.spanKind;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getName() {
        return this.name;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getSpanName() {
        return this.spanName;
    }

    public Context getContext() {
        return this.context;
    }

    public String getLocation() {
        return this.location;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new Builder(this.getName()).withErrorMessage(this.getErrorMessage()).withContext(this.getContext()).withTransactionId(this.getTransactionId()).withTags(this.getTags()).withSpanName(this.getSpanName()).withLocation(this.getLocation()).withSpanKind(this.getSpanKind()).withStatsCode(this.getStatusCode());
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public static final class Builder {
        public StatusCode statusCode;
        private Map<String, String> tags;
        private final String name;
        private String transactionId;
        private String spanName;
        private String location;
        private Context context;
        private SpanKind spanKind;
        private String errorMessage;

        private Builder(String name) {
            this.name = name;
        }

        public Builder withTags(Map<String, String> val) {
            this.tags = val;
            return this;
        }

        public Builder withTransactionId(String val) {
            this.transactionId = val;
            return this;
        }

        public Builder withSpanName(String val) {
            this.spanName = val;
            return this;
        }

        public Builder withLocation(String val) {
            this.location = val;
            return this;
        }

        public Builder withContext(Context val) {
            this.context = val;
            return this;
        }

        public Builder withSpanKind(SpanKind val) {
            this.spanKind = val;
            return this;
        }

        public Builder withErrorMessage(String val) {
            this.errorMessage = val;
            return this;
        }

        public Builder withStatsCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public TraceComponent build() {
            return new TraceComponent(this);
        }
    }
}

