/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor.service;

import com.avioconsulting.mule.opentelemetry.api.processor.ProcessorComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.util.LazyValue;

public class ProcessorComponentService {
    private static ProcessorComponentService service;
    private final List<ProcessorComponent> processorComponents;
    private static final LazyValue<ProcessorComponentService> VALUE;
    private final List<ProcessorComponent> cached = new ArrayList<ProcessorComponent>();

    private ProcessorComponentService() {
        ServiceLoader<ProcessorComponent> loader = ServiceLoader.load(ProcessorComponent.class, ProcessorComponent.class.getClassLoader());
        ArrayList lst = new ArrayList();
        loader.iterator().forEachRemaining(lst::add);
        this.processorComponents = Collections.unmodifiableList(lst);
    }

    public static synchronized ProcessorComponentService getInstance() {
        return (ProcessorComponentService)VALUE.get();
    }

    public Optional<ProcessorComponent> getProcessorComponentFor(ComponentIdentifier identifier, ConfigurationComponentLocator configurationComponentLocator) {
        Optional<ProcessorComponent> cachedPC = this.cached.stream().filter(p -> p.canHandle(identifier)).findFirst();
        if (!cachedPC.isPresent()) {
            this.processorComponents.stream().filter(p -> p.canHandle(identifier)).findFirst().map(pc -> pc.withConfigurationComponentLocator(configurationComponentLocator)).ifPresent(this.cached::add);
            cachedPC = this.cached.stream().filter(p -> p.canHandle(identifier)).findFirst();
        }
        return cachedPC;
    }

    static {
        VALUE = new LazyValue((Object)new ProcessorComponentService());
    }
}

