/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.internal.store.FlowSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.Transaction;
import com.avioconsulting.mule.opentelemetry.internal.store.TransactionStore;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTransactionStore
implements TransactionStore {
    private static TransactionStore service;
    private final ConcurrentHashMap<String, Transaction> transactionMap = new ConcurrentHashMap();
    private static final Logger LOGGER;

    public static synchronized TransactionStore getInstance() {
        if (service == null) {
            service = new InMemoryTransactionStore();
        }
        return service;
    }

    @Override
    public void startTransaction(String transactionId, String rootFlowName, SpanBuilder rootFlowSpan) {
        Optional<Transaction> transaction = this.getTransaction(transactionId);
        if (transaction.isPresent()) {
            LOGGER.trace("Start transaction {} for flow '{}' - Adding to existing transaction", (Object)transactionId, (Object)rootFlowName);
            transaction.get().getRootFlowSpan().addProcessorSpan(rootFlowName, rootFlowSpan);
        } else {
            Span span = rootFlowSpan.startSpan();
            LOGGER.trace("Start transaction {} for flow '{}': OT SpanId {}, TraceId {}", new Object[]{transactionId, rootFlowName, span.getSpanContext().getSpanId(), span.getSpanContext().getTraceId()});
            this.transactionMap.put(transactionId, new Transaction(transactionId, span.getSpanContext().getTraceId(), rootFlowName, new FlowSpan(rootFlowName, span)));
        }
    }

    @Override
    public void addTransactionTags(String transactionId, String tagPrefix, Map<String, String> tags) {
        AttributesBuilder builder = Attributes.builder();
        String format = "%s.%s";
        tags.forEach((k, v) -> builder.put(String.format(format, tagPrefix, k), v));
        this.getTransaction(transactionId).map(Transaction::getRootFlowSpan).map(FlowSpan::getSpan).ifPresent(span -> span.setAllAttributes(builder.build()));
    }

    private Optional<Transaction> getTransaction(String transactionId) {
        return Optional.ofNullable(this.transactionMap.get(transactionId));
    }

    @Override
    public Context getTransactionContext(String transactionId) {
        return this.getTransaction(transactionId).map(Transaction::getRootFlowSpan).map(FlowSpan::getSpan).map(s -> s.storeInContext(Context.current())).orElse(Context.current());
    }

    @Override
    public String getTraceIdForTransaction(String transactionId) {
        Optional<Transaction> transaction = this.getTransaction(transactionId);
        if (transaction.isPresent()) {
            return transaction.get().getTraceId();
        }
        return null;
    }

    @Override
    public void endTransaction(String transactionId, String rootFlowName, Consumer<Span> spanUpdater, Instant endTime) {
        LOGGER.trace("End transaction {} for flow '{}'", (Object)transactionId, (Object)rootFlowName);
        this.getTransaction(transactionId).filter(t -> rootFlowName.equalsIgnoreCase(t.getRootFlowName())).ifPresent(transaction -> {
            Transaction removed = this.transactionMap.remove(transactionId);
            Span rootSpan = removed.getRootFlowSpan().getSpan();
            if (spanUpdater != null) {
                spanUpdater.accept(rootSpan);
            }
            removed.getRootFlowSpan().end(endTime);
            LOGGER.trace("Ended transaction {} for flow '{}': OT SpanId {}, TraceId {}", new Object[]{transactionId, rootFlowName, rootSpan.getSpanContext().getSpanId(), rootSpan.getSpanContext().getTraceId()});
        });
    }

    @Override
    public void addProcessorSpan(String transactionId, String location, SpanBuilder spanBuilder) {
        this.getTransaction(transactionId).ifPresent(transaction -> {
            LOGGER.trace("Adding Processor span to transaction {} for location '{}'", (Object)transactionId, (Object)location);
            Span span = transaction.getRootFlowSpan().addProcessorSpan(location, spanBuilder);
            LOGGER.trace("Adding Processor span to transaction {} for locator span '{}': OT SpanId {}, TraceId {}", new Object[]{transactionId, location, span.getSpanContext().getSpanId(), span.getSpanContext().getTraceId()});
        });
    }

    @Override
    public void endProcessorSpan(String transactionId, String location, Consumer<Span> spanUpdater, Instant endTime) {
        LOGGER.trace("Ending Processor span of transaction {} for location '{}'", (Object)transactionId, (Object)location);
        this.getTransaction(transactionId).ifPresent(transaction -> transaction.getRootFlowSpan().endProcessorSpan(location, spanUpdater, endTime));
    }

    static {
        LOGGER = LoggerFactory.getLogger(InMemoryTransactionStore.class);
    }
}

