/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.config;

import com.avioconsulting.mule.opentelemetry.api.config.ExporterConfiguration;
import com.avioconsulting.mule.opentelemetry.api.config.OpenTelemetryResource;
import com.avioconsulting.mule.opentelemetry.api.config.SpanProcessorConfiguration;
import com.avioconsulting.mule.opentelemetry.api.config.TraceLevelConfiguration;
import com.avioconsulting.mule.opentelemetry.internal.OpenTelemetryOperations;
import com.avioconsulting.mule.opentelemetry.internal.config.OpenTelemetryConfigWrapper;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnectionProvider;
import com.avioconsulting.mule.opentelemetry.internal.listeners.MuleMessageProcessorNotificationListener;
import com.avioconsulting.mule.opentelemetry.internal.listeners.MulePipelineMessageNotificationListener;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={OpenTelemetryOperations.class})
@ConnectionProviders(value={OpenTelemetryConnectionProvider.class})
@Configuration
public class OpenTelemetryExtensionConfiguration
implements Startable,
Stoppable {
    public static final String PROP_MULE_OTEL_TRACING_DISABLED = "mule.otel.tracing.disabled";
    private final Logger logger = LoggerFactory.getLogger(OpenTelemetryExtensionConfiguration.class);
    @RefName
    private String configName;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Turn off tracing for this application.")
    private boolean turnOffTracing;
    @ParameterGroup(name="Resource")
    @Placement(order=10)
    @Summary(value="Open Telemetry Resource Configuration. System or Environment Variables will override this configuration.")
    private OpenTelemetryResource resource;
    @ParameterGroup(name="Exporter")
    @Placement(order=20)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private ExporterConfiguration exporterConfiguration;
    @ParameterGroup(name="Trace Levels")
    @Placement(order=30)
    private TraceLevelConfiguration traceLevelConfiguration;
    @ParameterGroup(name="Span Processor")
    @Placement(order=40, tab="Tracer Settings")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private SpanProcessorConfiguration spanProcessorConfiguration;
    @Inject
    NotificationListenerRegistry notificationListenerRegistry;
    @Inject
    MuleNotificationProcessor muleNotificationProcessor;

    public boolean isTurnOffTracing() {
        return System.getProperties().containsKey(PROP_MULE_OTEL_TRACING_DISABLED) ? Boolean.parseBoolean(System.getProperty(PROP_MULE_OTEL_TRACING_DISABLED)) : this.turnOffTracing;
    }

    public TraceLevelConfiguration getTraceLevelConfiguration() {
        return this.traceLevelConfiguration;
    }

    public ExporterConfiguration getExporterConfiguration() {
        return this.exporterConfiguration;
    }

    public SpanProcessorConfiguration getSpanProcessorConfiguration() {
        return this.spanProcessorConfiguration;
    }

    public OpenTelemetryResource getResource() {
        return this.resource;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void start() throws MuleException {
        if (this.isTurnOffTracing()) {
            this.logger.info("{} is set to true. Tracing will be turned off for config '{}'.", (Object)PROP_MULE_OTEL_TRACING_DISABLED, (Object)this.getConfigName());
            return;
        }
        this.logger.info("Initiating otel config - '{}'", (Object)this.getConfigName());
        this.muleNotificationProcessor.init(() -> OpenTelemetryConnection.getInstance(new OpenTelemetryConfigWrapper(this.getResource(), this.getExporterConfiguration().getExporter(), this.getSpanProcessorConfiguration())), this.getTraceLevelConfiguration());
        this.notificationListenerRegistry.registerListener((NotificationListener)new MuleMessageProcessorNotificationListener(this.muleNotificationProcessor));
        this.notificationListenerRegistry.registerListener((NotificationListener)new MulePipelineMessageNotificationListener(this.muleNotificationProcessor));
    }

    public void stop() throws MuleException {
        if (this.isTurnOffTracing()) {
            this.logger.info("{} is set to true. Configuration '{}' has been stopped.", (Object)PROP_MULE_OTEL_TRACING_DISABLED, (Object)this.getConfigName());
        }
    }
}

