/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.connection;

import com.avioconsulting.mule.opentelemetry.internal.OpenTelemetryUtil;
import com.avioconsulting.mule.opentelemetry.internal.config.OpenTelemetryConfigWrapper;
import com.avioconsulting.mule.opentelemetry.internal.connection.TraceContextHandler;
import com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.internal.processor.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.store.InMemoryTransactionStore;
import com.avioconsulting.mule.opentelemetry.internal.store.TransactionStore;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.events.GlobalEventEmitterProvider;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Error;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryConnection
implements TraceContextHandler {
    private final Logger logger = LoggerFactory.getLogger(OpenTelemetryConnection.class);
    private static final String INSTRUMENTATION_VERSION = "0.0.1-DEV";
    public final Map<String, String> OTEL_SYSTEM_PROPERTIES_MAP = System.getProperties().stringPropertyNames().stream().filter(p -> p.contains(".otel.")).collect(Collectors.toMap(String::toLowerCase, System::getProperty));
    private static final String INSTRUMENTATION_NAME = "mule-opentelemetry-module-DEV";
    private final TransactionStore transactionStore;
    private static OpenTelemetryConnection openTelemetryConnection;
    private final OpenTelemetry openTelemetry;
    private final Tracer tracer;

    private OpenTelemetryConnection(OpenTelemetryConfigWrapper openTelemetryConfigWrapper) {
        Properties properties = OpenTelemetryConnection.getModuleProperties();
        String instrumentationVersion = properties.getProperty("module.version", INSTRUMENTATION_VERSION);
        String instrumentationName = properties.getProperty("module.artifactId", INSTRUMENTATION_NAME);
        this.logger.info("Initialising OpenTelemetry Mule 4 Agent for instrumentation {}:{}", (Object)instrumentationName, (Object)instrumentationVersion);
        AutoConfiguredOpenTelemetrySdkBuilder builder = AutoConfiguredOpenTelemetrySdk.builder();
        if (openTelemetryConfigWrapper != null) {
            HashMap<String, String> configMap = new HashMap<String, String>();
            if (openTelemetryConfigWrapper.getResource() != null) {
                configMap.putAll(openTelemetryConfigWrapper.getResource().getConfigMap());
            }
            if (openTelemetryConfigWrapper.getExporter() != null) {
                configMap.putAll(openTelemetryConfigWrapper.getExporter().getExporterProperties());
            }
            if (openTelemetryConfigWrapper.getSpanProcessorConfiguration() != null) {
                configMap.putAll(openTelemetryConfigWrapper.getSpanProcessorConfiguration().getConfigMap());
            }
            builder.addPropertiesSupplier(() -> Collections.unmodifiableMap(configMap));
            this.logger.debug("Creating OpenTelemetryConnection with properties: [" + configMap + "]");
        }
        builder.setServiceClassLoader(AutoConfiguredOpenTelemetrySdkBuilder.class.getClassLoader());
        builder.setResultAsGlobal();
        this.openTelemetry = builder.build().getOpenTelemetrySdk();
        this.tracer = this.openTelemetry.getTracer(instrumentationName, instrumentationVersion);
        this.transactionStore = InMemoryTransactionStore.getInstance();
    }

    public static Supplier<OpenTelemetryConnection> supplier() {
        return () -> openTelemetryConnection;
    }

    public static void resetForTest() {
        GlobalOpenTelemetry.resetForTest();
        GlobalEventEmitterProvider.resetForTest();
        openTelemetryConnection = null;
    }

    public static synchronized OpenTelemetryConnection getInstance(OpenTelemetryConfigWrapper openTelemetryConfigWrapper) {
        if (openTelemetryConnection == null) {
            openTelemetryConnection = new OpenTelemetryConnection(openTelemetryConfigWrapper);
        }
        return openTelemetryConnection;
    }

    private static Properties getModuleProperties() {
        Properties moduleProperties = new Properties();
        try {
            InputStream resourceAsStream = OpenTelemetryConnection.class.getClassLoader().getResourceAsStream("mule-opentelemetry-module.properties");
            if (resourceAsStream != null) {
                moduleProperties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return moduleProperties;
    }

    public SpanBuilder spanBuilder(String spanName) {
        return this.tracer.spanBuilder(spanName);
    }

    @Override
    public <T> Context getTraceContext(T carrier, TextMapGetter<T> textMapGetter) {
        return this.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), carrier, textMapGetter);
    }

    public Map<String, String> getTraceContext(String transactionId) {
        return this.getTraceContext(transactionId, (ComponentLocation)null);
    }

    public Map<String, String> getTraceContext(String transactionId, ComponentLocation componentLocation) {
        Context transactionContext = this.getTransactionStore().getTransactionContext(transactionId, componentLocation);
        HashMap<String, String> traceContext = new HashMap<String, String>(10);
        traceContext.put("TRACE_TRANSACTION_ID", transactionId);
        traceContext.put("traceId", this.getTransactionStore().getTraceIdForTransaction(transactionId));
        this.injectTraceContext(transactionContext, traceContext, HashMapTextMapSetter.INSTANCE);
        this.logger.debug("Created trace context '{}' for TRACE_TRANSACTION_ID={}, Component Location '{}'", new Object[]{traceContext, transactionId, componentLocation});
        return traceContext;
    }

    @Override
    public <T> void injectTraceContext(T carrier, TextMapSetter<T> textMapSetter) {
        this.openTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), carrier, textMapSetter);
    }

    private <T> void injectTraceContext(Context context, T carrier, TextMapSetter<T> textMapSetter) {
        this.openTelemetry.getPropagators().getTextMapPropagator().inject(context, carrier, textMapSetter);
    }

    public TransactionStore getTransactionStore() {
        return this.transactionStore;
    }

    public void invalidate() {
    }

    public void addProcessorSpan(TraceComponent traceComponent, String rootContainerName) {
        SpanBuilder spanBuilder = this.spanBuilder(traceComponent.getSpanName()).setSpanKind(traceComponent.getSpanKind()).setStartTimestamp(traceComponent.getStartTime());
        OpenTelemetryUtil.addGlobalConfigSystemAttributes(traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_CONFIG_REF.getKey()), traceComponent.getTags(), this.OTEL_SYSTEM_PROPERTIES_MAP);
        traceComponent.getTags().forEach((arg_0, arg_1) -> ((SpanBuilder)spanBuilder).setAttribute(arg_0, arg_1));
        this.getTransactionStore().addProcessorSpan(traceComponent.getTransactionId(), rootContainerName, traceComponent.getLocation(), spanBuilder);
    }

    public void endProcessorSpan(TraceComponent traceComponent, Error error) {
        this.getTransactionStore().endProcessorSpan(traceComponent.getTransactionId(), traceComponent.getLocation(), span -> {
            if (error != null) {
                span.recordException(error.getCause());
            }
            this.setSpanStatus(traceComponent, (Span)span);
            if (traceComponent.getTags() != null) {
                traceComponent.getTags().forEach((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1));
            }
        }, traceComponent.getEndTime());
    }

    public void startTransaction(TraceComponent traceComponent) {
        SpanBuilder spanBuilder = openTelemetryConnection.spanBuilder(traceComponent.getSpanName()).setSpanKind(traceComponent.getSpanKind()).setParent(traceComponent.getContext()).setStartTimestamp(traceComponent.getStartTime());
        OpenTelemetryUtil.addGlobalConfigSystemAttributes(traceComponent.getTags().get(SemanticAttributes.MULE_APP_FLOW_SOURCE_CONFIG_REF.getKey()), traceComponent.getTags(), OpenTelemetryConnection.openTelemetryConnection.OTEL_SYSTEM_PROPERTIES_MAP);
        traceComponent.getTags().forEach((arg_0, arg_1) -> ((SpanBuilder)spanBuilder).setAttribute(arg_0, arg_1));
        this.getTransactionStore().startTransaction(traceComponent.getTransactionId(), traceComponent.getName(), spanBuilder);
    }

    public void endTransaction(TraceComponent traceComponent, Exception exception) {
        if (traceComponent != null) {
            openTelemetryConnection.getTransactionStore().endTransaction(traceComponent.getTransactionId(), traceComponent.getName(), rootSpan -> {
                traceComponent.getTags().forEach((arg_0, arg_1) -> ((Span)rootSpan).setAttribute(arg_0, arg_1));
                openTelemetryConnection.setSpanStatus(traceComponent, (Span)rootSpan);
                if (exception != null) {
                    rootSpan.recordException((Throwable)exception);
                }
            }, traceComponent.getEndTime());
        }
    }

    public void setSpanStatus(TraceComponent traceComponent, Span span) {
        if (traceComponent.getStatusCode() != null && !StatusCode.UNSET.equals((Object)traceComponent.getStatusCode())) {
            span.setStatus(traceComponent.getStatusCode());
        }
    }

    public static enum HashMapTextMapSetter implements TextMapSetter<Map<String, String>>
    {
        INSTANCE;


        public void set(@Nullable Map<String, String> carrier, String key, String value) {
            if (carrier != null) {
                carrier.put(key, value);
            }
        }
    }
}

