/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.connection;

import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryConnectionProvider
implements CachedConnectionProvider<Supplier<OpenTelemetryConnection>> {
    private final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryConnectionProvider.class);
    public static final String INSTRUMENTATION_VERSION = "0.0.1";
    public static final String INSTRUMENTATION_NAME = "com.avioconsulting.mule.tracing";
    @Inject
    NotificationListenerRegistry notificationListenerRegistry;

    public Supplier<OpenTelemetryConnection> connect() throws ConnectionException {
        return OpenTelemetryConnection.supplier();
    }

    public void disconnect(Supplier<OpenTelemetryConnection> connection) {
        try {
            connection.get().invalidate();
        }
        catch (Exception e) {
            this.LOGGER.error("Error while disconnecting OpenTelemetry: " + e.getMessage(), (Throwable)e);
        }
    }

    public ConnectionValidationResult validate(Supplier<OpenTelemetryConnection> connection) {
        return ConnectionValidationResult.success();
    }
}

