/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.processor.ProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.avioconsulting.mule.opentelemetry.internal.processor.TraceComponent;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessorComponent
implements ProcessorComponent {
    static final String NAMESPACE_URI_MULE = "http://www.mulesoft.org/schema/mule/core";
    public static final String NAMESPACE_MULE = "mule";
    public static final String FLOW = "flow";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProcessorComponent.class);
    protected ConfigurationComponentLocator configurationComponentLocator;

    @Override
    public ProcessorComponent withConfigurationComponentLocator(ConfigurationComponentLocator configurationComponentLocator) {
        this.configurationComponentLocator = configurationComponentLocator;
        return this;
    }

    protected abstract String getNamespace();

    protected abstract List<String> getOperations();

    protected abstract List<String> getSources();

    protected SpanKind getSpanKind() {
        return SpanKind.INTERNAL;
    }

    @Override
    public boolean canHandle(ComponentIdentifier componentIdentifier) {
        return this.getNamespace().equalsIgnoreCase(componentIdentifier.getNamespace()) && (this.getOperations().contains(componentIdentifier.getName().toLowerCase()) || this.getSources().contains(componentIdentifier.getName().toLowerCase()));
    }

    protected boolean namespaceSupported(ComponentIdentifier componentIdentifier) {
        return this.getNamespace().equalsIgnoreCase(componentIdentifier.getNamespace().toLowerCase());
    }

    protected boolean operationSupported(ComponentIdentifier componentIdentifier) {
        return this.getOperations().contains(componentIdentifier.getName().toLowerCase());
    }

    protected boolean sourceSupported(ComponentIdentifier componentIdentifier) {
        return this.getSources().contains(componentIdentifier.getName().toLowerCase());
    }

    @Override
    public TraceComponent getEndTraceComponent(EnrichedServerNotification notification) {
        return this.getTraceComponentBuilderFor(notification);
    }

    protected TraceComponent getTraceComponentBuilderFor(EnrichedServerNotification notification) {
        return TraceComponent.named(notification.getResourceIdentifier()).withTransactionId(this.getTransactionId(notification)).withLocation(notification.getComponent().getLocation().getLocation()).withTags(new HashMap<String, String>()).withErrorMessage(notification.getEvent().getError().map(Error::getDescription).orElse(null));
    }

    protected TraceComponent getBaseTraceComponent(EnrichedServerNotification notification) {
        return TraceComponent.named(notification.getComponent().getLocation().getLocation()).withLocation(notification.getComponent().getLocation().getLocation()).withSpanName(notification.getComponent().getIdentifier().getName()).withTransactionId(this.getTransactionId(notification));
    }

    protected String getDefaultSpanName(Map<String, String> tags) {
        String name = tags.get(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey());
        return name.concat(":").concat(tags.getOrDefault(SemanticAttributes.MULE_APP_PROCESSOR_DOC_NAME.getKey(), name));
    }

    protected String getTransactionId(EnrichedServerNotification notification) {
        return notification.getEvent().getCorrelationId();
    }

    protected Map<String, String> getProcessorCommonTags(Component component) {
        ComponentWrapper componentWrapper = new ComponentWrapper(component, this.configurationComponentLocator);
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(SemanticAttributes.MULE_APP_PROCESSOR_NAMESPACE.getKey(), component.getIdentifier().getNamespace());
        tags.put(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey(), component.getIdentifier().getName());
        if (componentWrapper.getDocName() != null) {
            tags.put(SemanticAttributes.MULE_APP_PROCESSOR_DOC_NAME.getKey(), componentWrapper.getDocName());
        }
        if (componentWrapper.getConfigRef() != null) {
            tags.put(SemanticAttributes.MULE_APP_PROCESSOR_CONFIG_REF.getKey(), componentWrapper.getConfigRef());
        }
        return tags;
    }

    protected ComponentIdentifier getSourceIdentifier(EnrichedServerNotification notification) {
        ComponentIdentifier sourceIdentifier = null;
        if (notification.getEvent() != null && notification.getEvent().getContext().getOriginatingLocation() != null && notification.getResourceIdentifier().equalsIgnoreCase(notification.getEvent().getContext().getOriginatingLocation().getRootContainerName())) {
            sourceIdentifier = notification.getEvent().getContext().getOriginatingLocation().getComponentIdentifier().getIdentifier();
        }
        return sourceIdentifier;
    }

    protected <A> Map<String, String> getAttributes(Component component, TypedValue<A> attributes) {
        return Collections.emptyMap();
    }

    @Override
    public TraceComponent getStartTraceComponent(EnrichedServerNotification notification) {
        return this.getStartTraceComponent(notification.getComponent(), notification.getEvent().getMessage(), this.getTransactionId(notification));
    }

    @Override
    public TraceComponent getStartTraceComponent(Component component, Message message, String correlationId) {
        HashMap<String, String> tags = new HashMap<String, String>(this.getProcessorCommonTags(component));
        tags.put(SemanticAttributes.MULE_CORRELATION_ID.getKey(), correlationId);
        tags.putAll(this.getAttributes(component, message.getAttributes()));
        return TraceComponent.named(component.getLocation().getLocation()).withLocation(component.getLocation().getLocation()).withSpanName(this.getDefaultSpanName(tags)).withTags(tags).withSpanKind(this.getSpanKind()).withTransactionId(correlationId);
    }

    protected void addTagIfPresent(Map<String, String> sourceMap, String sourceKey, Map<String, String> targetMap, String targetKey) {
        if (sourceMap.containsKey(sourceKey)) {
            targetMap.put(targetKey, sourceMap.get(sourceKey));
        }
    }

    protected Optional<Component> getSourceComponent(EnrichedServerNotification notification) {
        return this.configurationComponentLocator.find(Location.builderFromStringRepresentation((String)notification.getEvent().getContext().getOriginatingLocation().getLocation()).build());
    }

    protected static enum ContextMapGetter implements TextMapGetter<Map<String, String>>
    {
        INSTANCE;


        public Iterable<String> keys(Map<String, String> map) {
            return map.keySet();
        }

        @Nullable
        public String get(@Nullable Map<String, String> map, String s) {
            return map == null ? null : map.get(s);
        }
    }
}

