/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.internal.store.FlowSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.Transaction;
import com.avioconsulting.mule.opentelemetry.internal.store.TransactionStore;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTransactionStore
implements TransactionStore {
    private static TransactionStore service;
    private final ConcurrentHashMap<String, Transaction> transactionMap = new ConcurrentHashMap();
    private static final Logger LOGGER;

    public static synchronized TransactionStore getInstance() {
        if (service == null) {
            service = new InMemoryTransactionStore();
        }
        return service;
    }

    @Override
    public void startTransaction(String transactionId, String rootFlowName, SpanBuilder rootFlowSpan) {
        Transaction transaction = this.getTransaction(transactionId);
        if (transaction != null) {
            LOGGER.trace("Start transaction {} for flow '{}' - Adding to existing transaction", (Object)transactionId, (Object)rootFlowName);
            transaction.getRootFlowSpan().addProcessorSpan(null, rootFlowName, rootFlowSpan);
        } else {
            Span span = rootFlowSpan.startSpan();
            LOGGER.trace("Start transaction {} for flow '{}': OT SpanId {}, TraceId {}", new Object[]{transactionId, rootFlowName, span.getSpanContext().getSpanId(), span.getSpanContext().getTraceId()});
            this.transactionMap.put(transactionId, new Transaction(transactionId, span.getSpanContext().getTraceId(), rootFlowName, new FlowSpan(rootFlowName, span)));
        }
    }

    @Override
    public void addTransactionTags(String transactionId, String tagPrefix, Map<String, String> tags) {
        AttributesBuilder builder = Attributes.builder();
        String format = "%s.%s";
        tags.forEach((k, v) -> builder.put(String.format(format, tagPrefix, k), v));
        Transaction transaction = this.getTransaction(transactionId);
        Span span = transaction.getRootFlowSpan().getSpan();
        if (span != null) {
            span.setAllAttributes(builder.build());
        }
    }

    private Transaction getTransaction(String transactionId) {
        return this.transactionMap.get(transactionId);
    }

    private Context getTransactionContext(Transaction transaction) {
        return transaction == null ? Context.current() : transaction.getRootFlowSpan().getSpan().storeInContext(Context.current());
    }

    @Override
    public Context getTransactionContext(String transactionId, ComponentLocation componentLocation) {
        Transaction transaction = this.getTransaction(transactionId);
        if (componentLocation == null) {
            return this.getTransactionContext(transaction);
        }
        Span span = null;
        if (transaction != null && (span = transaction.getRootFlowSpan().findSpan(componentLocation.getLocation())) != null) {
            return span.storeInContext(Context.current());
        }
        return this.getTransactionContext(transaction);
    }

    @Override
    public String getTraceIdForTransaction(String transactionId) {
        return this.transactionMap.containsKey(transactionId) ? this.getTransaction(transactionId).getTraceId() : null;
    }

    @Override
    public void endTransaction(String transactionId, String flowName, Consumer<Span> spanUpdater, Instant endTime) {
        LOGGER.trace("End transaction {} for flow '{}'", (Object)transactionId, (Object)flowName);
        Consumer<Span> endSpan = span -> {
            if (spanUpdater != null) {
                spanUpdater.accept((Span)span);
            }
            span.end(endTime);
            LOGGER.trace("Ended transaction {} for flow '{}': OT SpanId {}, TraceId {}", new Object[]{transactionId, flowName, span.getSpanContext().getSpanId(), span.getSpanContext().getTraceId()});
        };
        Transaction transaction = this.getTransaction(transactionId);
        if (transaction != null) {
            if (transaction.getRootFlowName().equals(flowName)) {
                Transaction removed = this.transactionMap.remove(transactionId);
                endSpan.accept(removed.getRootFlowSpan().getSpan());
            } else {
                Span span2 = transaction.getRootFlowSpan().findSpan(flowName);
                if (span2 != null) {
                    endSpan.accept(span2);
                }
            }
        }
    }

    @Override
    public void addProcessorSpan(String transactionId, String containerName, String location, SpanBuilder spanBuilder) {
        Transaction transaction = this.getTransaction(transactionId);
        if (transaction == null) {
            return;
        }
        LOGGER.trace("Adding Processor span to transaction {} for location '{}'", (Object)transactionId, (Object)location);
        Span span = transaction.getRootFlowSpan().addProcessorSpan(containerName, location, spanBuilder);
        LOGGER.trace("Adding Processor span to transaction {} for locator span '{}': OT SpanId {}, TraceId {}", new Object[]{transactionId, location, span.getSpanContext().getSpanId(), span.getSpanContext().getTraceId()});
    }

    @Override
    public void endProcessorSpan(String transactionId, String location, Consumer<Span> spanUpdater, Instant endTime) {
        LOGGER.trace("Ending Processor span of transaction {} for location '{}'", (Object)transactionId, (Object)location);
        Transaction transaction = this.getTransaction(transactionId);
        if (transaction != null) {
            transaction.getRootFlowSpan().endProcessorSpan(location, spanUpdater, endTime);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(InMemoryTransactionStore.class);
    }
}

