/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;

public interface TransactionStore {
    public static final String TRACE_TRANSACTION_ID = "TRACE_TRANSACTION_ID";
    public static final String TRACE_CONTEXT_MAP_KEY = "OTEL_TRACE_CONTEXT";
    public static final String TRACE_ID = "traceId";

    default public String transactionIdFor(Event muleEvent) {
        return muleEvent.getCorrelationId();
    }

    public void startTransaction(String var1, String var2, SpanBuilder var3);

    public void addTransactionTags(String var1, String var2, Map<String, String> var3);

    public Context getTransactionContext(String var1, ComponentLocation var2);

    public String getTraceIdForTransaction(String var1);

    default public void endTransaction(String transactionId, String rootFlowName) {
        this.endTransaction(transactionId, rootFlowName, null);
    }

    default public void endTransaction(String transactionId, String rootFlowName, Consumer<Span> spanUpdater) {
        this.endTransaction(transactionId, rootFlowName, spanUpdater, null);
    }

    public void endTransaction(String var1, String var2, Consumer<Span> var3, Instant var4);

    public void addProcessorSpan(String var1, String var2, String var3, SpanBuilder var4);

    default public void endProcessorSpan(String transactionId, String location) {
        this.endProcessorSpan(transactionId, location, span -> {});
    }

    default public void endProcessorSpan(String transactionId, String location, Consumer<Span> spanUpdater) {
        this.endProcessorSpan(transactionId, location, spanUpdater, null);
    }

    public void endProcessorSpan(String var1, String var2, Consumer<Span> var3, Instant var4);
}

