/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.config.metrics;

import com.avioconsulting.mule.opentelemetry.api.config.metrics.MetricsInstrumentType;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="Metric Instrument")
public class CustomMetricInstrumentDefinition {
    @Parameter
    @Placement(order=1)
    @Summary(value="Name of the Metric Instrument. See OpenTelemetry Semantic Conventions for <a href='https://github.com/open-telemetry/semantic-conventions/blob/main/docs/general/metrics.md#instrument-naming'>Instrument Naming Guidelines</a>")
    @Example(value="org.business.orders.count")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String metricName;
    @Parameter
    @Placement(order=2)
    @Optional(defaultValue="COUNTER")
    @DisplayName(value="Instrument Type")
    @Summary(value="Type of the instrument to use such as Counter, Histogram, Gauge etc.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private MetricsInstrumentType instrumentType;
    @Parameter
    @Placement(order=3)
    @Summary(value="Description of the Metric Instrument")
    @Example(value="Count the number of orders received")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String description;
    @Parameter
    @Placement(order=4)
    @Summary(value="Unit of the Metric Instrument")
    @Example(value="1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String unit;
    @Parameter
    @Placement(order=5)
    @Optional
    @Summary(value="List of the attribute keys that can be added to this metric value")
    @Example(value="org.business.order.channel.source")
    @NullSafe
    @Alias(value="attribute-keys")
    private List<String> attributeKeys;

    public String getMetricName() {
        return this.metricName;
    }

    public CustomMetricInstrumentDefinition setMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUnit() {
        return this.unit;
    }

    public List<String> getAttributeKeys() {
        return this.attributeKeys;
    }

    public MetricsInstrumentType getInstrumentType() {
        return this.instrumentType;
    }

    public CustomMetricInstrumentDefinition setInstrumentType(MetricsInstrumentType instrumentType) {
        this.instrumentType = instrumentType;
        return this;
    }

    public CustomMetricInstrumentDefinition setDescription(String description) {
        this.description = description;
        return this;
    }

    public CustomMetricInstrumentDefinition setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public CustomMetricInstrumentDefinition setAttributeKeys(List<String> attributeKeys) {
        this.attributeKeys = attributeKeys;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomMetricInstrumentDefinition that = (CustomMetricInstrumentDefinition)o;
        return Objects.equals(this.getMetricName(), that.getMetricName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getUnit(), that.getUnit()) && this.getInstrumentType() == that.getInstrumentType() && Objects.equals(this.getAttributeKeys(), that.getAttributeKeys());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getMetricName(), this.getDescription(), this.getUnit(), this.getInstrumentType(), this.getAttributeKeys()});
    }
}

