/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.interceptor;

import com.avioconsulting.mule.opentelemetry.api.processor.ProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import com.avioconsulting.mule.opentelemetry.internal.processor.TraceComponent;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.ThreadSafe;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ProcessorTracingInterceptor
implements ProcessorInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorTracingInterceptor.class);
    private final MuleNotificationProcessor muleNotificationProcessor;
    private final ConfigurationComponentLocator configurationComponentLocator;
    private OpenTelemetryConnection openTelemetryConnection;

    public ProcessorTracingInterceptor(MuleNotificationProcessor muleNotificationProcessor, ConfigurationComponentLocator configurationComponentLocator) {
        this.muleNotificationProcessor = muleNotificationProcessor;
        this.configurationComponentLocator = configurationComponentLocator;
    }

    public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
        if (this.muleNotificationProcessor.getConnectionSupplier() != null) {
            ProcessorComponent processorComponent;
            if (this.openTelemetryConnection == null) {
                this.openTelemetryConnection = this.muleNotificationProcessor.getConnectionSupplier().get();
            }
            if ((processorComponent = this.muleNotificationProcessor.getProcessorComponent(location.getComponentIdentifier().getIdentifier())) == null) {
                String transactionId = this.openTelemetryConnection.getTransactionStore().transactionIdFor((Event)event);
                event.addVariable("OTEL_TRACE_CONTEXT", this.openTelemetryConnection.getTraceContext(transactionId));
            } else {
                Optional<TraceComponent> traceComponent = this.configurationComponentLocator.find(Location.builderFromStringRepresentation((String)location.getLocation()).build()).map(c -> processorComponent.getStartTraceComponent((Component)c, event.getMessage(), event.getCorrelationId()));
                if (!traceComponent.isPresent()) {
                    LOGGER.warn("Could not build a trace component for {} at {}", (Object)location.getComponentIdentifier().getIdentifier(), (Object)location.getLocation());
                    return;
                }
                traceComponent.ifPresent(tc -> {
                    LOGGER.trace("Creating Span in the interceptor for {} at {}", (Object)location.getComponentIdentifier().getIdentifier(), (Object)location.getLocation());
                    this.openTelemetryConnection.addProcessorSpan((TraceComponent)tc, location.getRootContainerName());
                    String transactionId = this.openTelemetryConnection.getTransactionStore().transactionIdFor((Event)event);
                    event.addVariable("OTEL_TRACE_CONTEXT", this.openTelemetryConnection.getTraceContext(transactionId, location));
                });
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Intercepted with logic '{}'", (Object)location);
            }
        }
    }

    public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
        if (this.muleNotificationProcessor.getConnectionSupplier() != null && LOGGER.isTraceEnabled()) {
            LOGGER.trace("Variables around the interceptor for {} - {}", (Object)location.getLocation(), (Object)event.getVariables().toString());
        }
        return action.proceed();
    }
}

