/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk.test;

import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DelegatedLoggingSpanTestExporter
implements SpanExporter {
    private static final LoggingSpanExporter exporter = LoggingSpanExporter.create();
    public static final Queue<Span> spanQueue = new ConcurrentLinkedQueue<Span>();
    private final ConfigProperties config;
    private static final Logger logger = Logger.getLogger(DelegatedLoggingSpanTestExporter.class.getName());

    public DelegatedLoggingSpanTestExporter(ConfigProperties config) {
        this.config = config;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        spans.stream().map(spanData -> {
            Span span = new Span();
            span.setSpanName(spanData.getName());
            span.setSpanId(spanData.getSpanId());
            span.setSpanKind(spanData.getKind().toString());
            span.setTraceId(spanData.getTraceId());
            span.setSpanStatus(spanData.getStatus().getStatusCode().name());
            span.setInstrumentationName(spanData.getInstrumentationScopeInfo().getName());
            span.setInstrumentationVersion(spanData.getInstrumentationScopeInfo().getVersion());
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            spanData.getAttributes().forEach((key, value) -> attributes.put(key.getKey(), value));
            span.setAttributes(attributes);
            span.setSpanContext(new SpanContext(spanData.getSpanContext()));
            span.setParentSpanContext(new SpanContext(spanData.getParentSpanContext()));
            logger.log(Level.INFO, span.toString());
            return span;
        }).forEach(spanQueue::add);
        return exporter.export(spans);
    }

    public CompletableResultCode flush() {
        spanQueue.clear();
        return exporter.flush();
    }

    public CompletableResultCode shutdown() {
        return this.flush();
    }

    public ConfigProperties getConfig() {
        return this.config;
    }

    public static class SpanContext {
        private final String traceId;
        private final String spanId;

        public SpanContext(io.opentelemetry.api.trace.SpanContext spanContext) {
            this.spanId = spanContext.getSpanId();
            this.traceId = spanContext.getTraceId();
        }

        public String getTraceId() {
            return this.traceId;
        }

        public String getSpanId() {
            return this.spanId;
        }

        public String toString() {
            return "SpanContext{traceId='" + this.traceId + '\'' + ", spanId='" + this.spanId + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpanContext that = (SpanContext)o;
            return Objects.equals(this.getTraceId(), that.getTraceId()) && Objects.equals(this.getSpanId(), that.getSpanId());
        }

        public int hashCode() {
            return Objects.hash(this.getTraceId(), this.getSpanId());
        }
    }

    public static class Span {
        private String instrumentationName;
        private String instrumentationVersion;
        private String spanName;
        private String traceId;
        private String spanId;
        private String spanKind;
        private String spanStatus;
        private Map<String, Object> attributes;
        private SpanContext parentSpanContext;
        private SpanContext spanContext;

        public String getInstrumentationName() {
            return this.instrumentationName;
        }

        public void setInstrumentationName(String instrumentationName) {
            this.instrumentationName = instrumentationName;
        }

        public String getInstrumentationVersion() {
            return this.instrumentationVersion;
        }

        public void setInstrumentationVersion(String instrumentationVersion) {
            this.instrumentationVersion = instrumentationVersion;
        }

        public String getSpanStatus() {
            return this.spanStatus;
        }

        public void setSpanStatus(String spanStatus) {
            this.spanStatus = spanStatus;
        }

        public void setSpanName(String spanName) {
            this.spanName = spanName;
        }

        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        public void setSpanId(String spanId) {
            this.spanId = spanId;
        }

        public void setSpanKind(String spanKind) {
            this.spanKind = spanKind;
        }

        public void setAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        public String getSpanName() {
            return this.spanName;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public String getSpanId() {
            return this.spanId;
        }

        public String getSpanKind() {
            return this.spanKind;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public SpanContext getParentSpanContext() {
            return this.parentSpanContext;
        }

        public void setParentSpanContext(SpanContext parentSpanContext) {
            this.parentSpanContext = parentSpanContext;
        }

        public SpanContext getSpanContext() {
            return this.spanContext;
        }

        public void setSpanContext(SpanContext spanContext) {
            this.spanContext = spanContext;
        }

        public String toString() {
            return "Span{instrumentationName='" + this.instrumentationName + '\'' + ", instrumentationVersion='" + this.instrumentationVersion + '\'' + ", spanName='" + this.spanName + '\'' + ", traceId='" + this.traceId + '\'' + ", spanId='" + this.spanId + '\'' + ", spanKind='" + this.spanKind + '\'' + ", spanStatus='" + this.spanStatus + '\'' + ", attributes=" + this.attributes + ", parentSpanContext=" + this.parentSpanContext + ", spanContext=" + this.spanContext + '}';
        }
    }
}

