/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.Map;

public class TraceComponent {
    private Map<String, String> tags;
    private final String name;
    private String transactionId;
    private String spanName;
    private String location;
    private Context context;
    private SpanKind spanKind;
    private String errorMessage;
    private StatusCode statusCode;
    private Instant startTime = Instant.now();
    private Instant endTime;

    private TraceComponent(String name) {
        this.name = name;
    }

    public static TraceComponent named(String name) {
        return new TraceComponent(name);
    }

    public SpanKind getSpanKind() {
        return this.spanKind;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getName() {
        return this.name;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getSpanName() {
        return this.spanName;
    }

    public Context getContext() {
        return this.context;
    }

    public String getLocation() {
        return this.location;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public TraceComponent withTags(Map<String, String> val) {
        this.tags = val;
        return this;
    }

    public TraceComponent withTransactionId(String val) {
        this.transactionId = val;
        return this;
    }

    public TraceComponent withSpanName(String val) {
        this.spanName = val;
        return this;
    }

    public TraceComponent withLocation(String val) {
        this.location = val;
        return this;
    }

    public TraceComponent withContext(Context val) {
        this.context = val;
        return this;
    }

    public TraceComponent withSpanKind(SpanKind val) {
        this.spanKind = val;
        return this;
    }

    public TraceComponent withErrorMessage(String val) {
        this.errorMessage = val;
        return this;
    }

    public TraceComponent withStatsCode(StatusCode statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public TraceComponent withStartTime(Instant startTime) {
        this.startTime = startTime;
        return this;
    }

    public TraceComponent withEndTime(Instant endTime) {
        this.endTime = endTime;
        return this;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }
}

