/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.internal.processor.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.store.ProcessorSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.SpanMeta;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class FlowSpan
implements Serializable {
    private final String flowName;
    private final Span span;
    private final String transactionId;
    private final Map<String, ProcessorSpan> childSpans = new ConcurrentHashMap<String, ProcessorSpan>();
    private Map<String, String> tags = new HashMap<String, String>();

    public FlowSpan(String flowName, Span span, String transactionId) {
        this.flowName = flowName;
        this.span = span;
        this.transactionId = transactionId;
    }

    public Span getSpan() {
        return this.span;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public SpanMeta addProcessorSpan(String containerName, TraceComponent traceComponent, SpanBuilder spanBuilder) {
        if (containerName != null) {
            ProcessorSpan ps = new ProcessorSpan(this.getSpan(), traceComponent.getLocation(), this.transactionId, traceComponent.getStartTime(), this.flowName).setTags(this.getTags());
            ProcessorSpan parentSpan = this.childSpans.getOrDefault(containerName, ps);
            spanBuilder.setParent(parentSpan.getContext());
        }
        Span span = spanBuilder.startSpan();
        ProcessorSpan ps = new ProcessorSpan(span, traceComponent.getLocation(), this.transactionId, traceComponent.getStartTime(), this.flowName).setTags(traceComponent.getTags());
        this.childSpans.put(traceComponent.getLocation(), ps);
        return ps;
    }

    public SpanMeta endProcessorSpan(String location, Consumer<ProcessorSpan> spanUpdater, Instant endTime) {
        if (this.childSpans.containsKey(location)) {
            ProcessorSpan removed = this.childSpans.remove(location);
            removed.setEndTime(endTime);
            if (spanUpdater != null) {
                spanUpdater.accept(removed);
            }
            removed.getSpan().end(endTime);
            return removed;
        }
        return null;
    }

    public ProcessorSpan findSpan(String location) {
        return this.childSpans.get(location);
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public FlowSpan setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }
}

